/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;

public class VCFHeader {
    private final Set<VCFHeaderLine> mMetaData;
    private final Map<String, VCFInfoHeaderLine> mInfoMetaData = new HashMap<String, VCFInfoHeaderLine>();
    private final Map<String, VCFFormatHeaderLine> mFormatMetaData = new HashMap<String, VCFFormatHeaderLine>();
    private final Map<String, VCFHeaderLine> mOtherMetaData = new HashMap<String, VCFHeaderLine>();
    private final Set<String> mGenotypeSampleNames = new LinkedHashSet<String>();
    public static final String METADATA_INDICATOR = "##";
    public static final String HEADER_INDICATOR = "#";
    private boolean hasGenotypingData = false;
    private boolean samplesWereAlreadySorted = true;

    public VCFHeader(Set<VCFHeaderLine> metaData) {
        this.mMetaData = new TreeSet<VCFHeaderLine>(metaData);
        this.loadVCFVersion();
        this.loadMetaDataMaps();
    }

    public VCFHeader(Set<VCFHeaderLine> metaData, Set<String> genotypeSampleNames) {
        this.mMetaData = new TreeSet<VCFHeaderLine>();
        if (metaData != null) {
            this.mMetaData.addAll(metaData);
        }
        for (String col : genotypeSampleNames) {
            if (col.equals("FORMAT")) continue;
            this.mGenotypeSampleNames.add(col);
        }
        if (genotypeSampleNames.size() > 0) {
            this.hasGenotypingData = true;
        }
        this.loadVCFVersion();
        this.loadMetaDataMaps();
        this.samplesWereAlreadySorted = ParsingUtils.isSorted(genotypeSampleNames);
    }

    public void addMetaDataLine(VCFHeaderLine headerLine) {
        this.mMetaData.add(headerLine);
    }

    public void loadVCFVersion() {
        ArrayList<VCFHeaderLine> toRemove = new ArrayList<VCFHeaderLine>();
        for (VCFHeaderLine line : this.mMetaData) {
            if (!VCFHeaderVersion.isFormatString(line.getKey())) continue;
            toRemove.add(line);
        }
        this.mMetaData.removeAll(toRemove);
    }

    private void loadMetaDataMaps() {
        for (VCFHeaderLine line : this.mMetaData) {
            if (line instanceof VCFInfoHeaderLine) {
                VCFInfoHeaderLine infoLine = (VCFInfoHeaderLine)line;
                this.mInfoMetaData.put(infoLine.getName(), infoLine);
                continue;
            }
            if (line instanceof VCFFormatHeaderLine) {
                VCFFormatHeaderLine formatLine = (VCFFormatHeaderLine)line;
                this.mFormatMetaData.put(formatLine.getName(), formatLine);
                continue;
            }
            this.mOtherMetaData.put(line.getKey(), line);
        }
    }

    public Set<HEADER_FIELDS> getHeaderFields() {
        LinkedHashSet<HEADER_FIELDS> fields = new LinkedHashSet<HEADER_FIELDS>();
        for (HEADER_FIELDS field : HEADER_FIELDS.values()) {
            fields.add(field);
        }
        return fields;
    }

    public Set<VCFHeaderLine> getMetaData() {
        LinkedHashSet<VCFHeaderLine> lines = new LinkedHashSet<VCFHeaderLine>();
        lines.add(new VCFHeaderLine(VCFHeaderVersion.VCF4_0.getFormatString(), VCFHeaderVersion.VCF4_0.getVersionString()));
        lines.addAll(this.mMetaData);
        return Collections.unmodifiableSet(lines);
    }

    public Set<String> getGenotypeSamples() {
        return this.mGenotypeSampleNames;
    }

    public boolean hasGenotypingData() {
        return this.hasGenotypingData;
    }

    public boolean samplesWereAlreadySorted() {
        return this.samplesWereAlreadySorted;
    }

    public int getColumnCount() {
        return HEADER_FIELDS.values().length + (this.hasGenotypingData ? this.mGenotypeSampleNames.size() + 1 : 0);
    }

    public VCFInfoHeaderLine getInfoHeaderLine(String key) {
        return this.mInfoMetaData.get(key);
    }

    public VCFFormatHeaderLine getFormatHeaderLine(String key) {
        return this.mFormatMetaData.get(key);
    }

    public VCFHeaderLine getOtherHeaderLine(String key) {
        return this.mOtherMetaData.get(key);
    }

    public static enum HEADER_FIELDS {
        CHROM,
        POS,
        ID,
        REF,
        ALT,
        QUAL,
        FILTER,
        INFO;

    }
}

