//==============================================================================================
//  build.cc                                                                       Font3D
//----------------------------------------------------------------------------------------------
//
//  Copyright (c) 1994-1996 by Todd A. Prater                                   Version 1.60 
//  All rights reserved. 
//
//----------------------------------------------------------------------------------------------
//
//  Permission to copy and distribute Font3D in its entirety, for noncommercial purposes,
//  is hereby granted without fee, provided that this license information and copyright 
//  notice appear in all copies. 
//
//  If you redistribute Font3D, the entire contents of this distribution must be distributed,
//  including the readme.txt, and register.txt files, and the complete set of documentation,
//  both ASCII text, and PostScript files. 
//
//  The software may be modified for your own purposes, but modified versions may not be
//  distributed without prior consent of the author.
//
//  This software is provided 'asis', without any express or implied warranty.  In no event
//  will the author be held liable for any damages arising from the use of this software.  
//
//  If you would like to do something with Font3D that this copyright prohibits (such as 
//  distributing it with a commercial product, using portions of the source in some other
//  program, distributing registered copies, etc.), please contact the author (preferably
//  via email).  Arrangements can probably be worked out.
//
//==============================================================================================

#ifndef __BUILD_H__
#define __BUILD_H__

#include <iostream.h>

#include "truetype.h"
#include "geometry.h"
#include "font3d.h"

#define INSIDE  0
#define OUTSIDE 1
#define IGNORE  2
#define COMBINED 3

#define BLD_ERR_NoError       0
#define BLD_ERR_OutOfMemory   1


void PolygonizeContour(TTFont&, int, int, int, double, POLYGON&);
 
int CreateFaces(TTFont& font,int  glyphnum, Font3DOptions& options,
                vector offset, TRIANGLELIST& frontTriangleList,
                TRIANGLELIST& backTriangleList);

int CreateSides(TTFont& font, int    glyphnum, Font3DOptions& options,
                vector offset, TRIANGLELIST& frontBevelTriangleList,
                TRIANGLELIST& backBevelTriangleList,
                TRIANGLELIST& sideTriangleList);

#endif
