/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
global m

// Add a menu item that invokes a given Floater command (as if typed by user).
proc simple {label {command <none>}} {
    global m

    if {"<none>" == $command} {set command $label}
    $m add command -label $label -command "command \"$command\""
//    puts "$m add command -label $label -command \"command \"$command\"\""
}

// Add a radiobutton menu item that invokes a given Floater command
// (as if typed by user).
proc addrb {var label {command <none>} {value <none>}} {
    global m

    if {"<none>" == $command} {set command $label}
    if {"<none>" == $value} {set value $label}
    $m add radiobutton -label $label -command "command \"$command\"" \
	    -variable $var -value "$value"
}

// Create a cascaded menu and optionally add some simple commands.
proc cascade {label {subcommands {}}} {
    global m

    $m add cascade -label $label -menu [set m2 "$m.cas$label"]
    menu $m2 -tearoff no
    set oldm $m
    set m $m2
    foreach sub $subcommands {
	eval "simple $sub"
    }
    set m $oldm
    return $m2
}

// Create a cascaded menu and optionally add some radiobuttons.
proc rcascade {label var {subcommands {}}} {
    global m

    $m add cascade -label $label -menu [set m2 "$m.cas[join $label _]"]
    menu $m2 -tearoff no
    set oldm $m
    set m $m2
    foreach sub $subcommands {
	eval "addrb $var $sub"
    }
    set m $oldm
    return $m2
}


set m [menu .menu.file -tearoff no]
.menu add cascade -menu $m -label File -underline 0

if {$tcl_platform(platform) == "macintosh"} {
    .menu add cascade -menu .menu.apple
    menu .menu.apple -tearoff no
    .menu.apple add command -label "About..." -command {command about}
} else {
    .menu.file add command -label "About..." -command {command about}
//	-underline 0 -accelerator "<F1>"
    .menu.file add separator
}

// simple "About..." about
// $m add separator
simple "Login..." login
simple "Change Password..." password
if {$tk_version >= 4.2} {
    simple "Load CC..." ccload 
    simple "Save CC..." ccsave
    simple "Execute File..." execute
    if {$tcl_platform(platform) == "macintosh"} {
	set needseated_fmenu_entries {2 3}
    } else {
	set needseated_fmenu_entries {4 5}
    }
} else {
    set needseated_fmenu_entries {} 
}
$m add separator
simple Quit

// join menu ////////////////////////////////////////////////////////////////

set m [menu .menu.join -tearoff no]
.menu add cascade -menu $m -label Join -underline 0

proc no_tables_to_join {b} {
    if $b {
	global join_menu_length join_menu
	.menu.join delete 0 end
	.menu.join add command -label "(none)" -state disabled
	.menu.join add separator
	.menu.join add command -label "Check for tables" \
		-command "command tables"
	set join_menu_length 0
	foreach i [array names join_menu] { unset join_menu($i) }
    } else {
	catch {.menu.join delete "(none)"}
    }
}

no_tables_to_join 1

proc join_menu_add_table {name fullname} {
    global join_menu_length join_menu

    if [info exists join_menu($name)] {
	if {$fullname != $join_menu($name)} {
	    .menu.join entryconfigure $join_menu($name) -label $fullname
	    set join_menu($name) $fullname
	}
	return
    }
    if {[incr join_menu_length] == 1} {no_tables_to_join 0}
    set join_menu($name) $fullname
    .menu.join insert 0 command -label $fullname -command "command \"join $name\""
}

proc join_menu_remove_table {name} {
    global join_menu_length join_menu

    if ![info exists join_menu($name)] return
    .menu.join delete $join_menu($name)
    if {[incr join_menu_length -1] == 0} {
	no_tables_to_join 1
    } else {
	unset join_menu($name)
    }
}    

// table menu ////////////////////////////////////////////////////////////////

set m [menu .menu.table -tearoff no]
.menu add cascade -menu $m -label Table -underline 0

simple Host
$m add separator
cascade Sit {North South East West}
simple Kibitz
simple Spec
$m add separator
cascade Communications {Disconnect {"Show Parent" parent} \
	{"Show Children" children} {"Show Net Location" ip}}
simple "Show who's here" who
simple "Beep everyone" beep
set needtable_tmenu_entries {2 3 4 6 7 8}

// bridge menu //////////////////////////////////////////////////////////////

set m [menu .menu.bridge -tearoff no]
.menu add cascade -menu $m -label Bridge -underline 0

set claimmenu [cascade Claim]
foreach i {13 12 11 10 9 8 7 6 5 4 3 2 1 0} {
    $claimmenu add command -label "$i tricks" -command "GUIclaim $i"
}
simple "Accept claim" accept
simple "Reject claim" reject
simple "Retract claim" retract
simple Review
simple "Show initial cards" cards
simple "Show last trick" last
simple "Show EW CC" {ccdump EW}
simple "Show NS CC" {ccdump NS}
$m add separator
set scoringmenu [cascade Scoring]
$scoringmenu add radiobutton -label IMP -command "command \"score IMP\"" \
	-variable radioscoring
$scoringmenu add radiobutton -label MP -command "command \"score MP\"" \
	-variable radioscoring
$scoringmenu add radiobutton -label Rubber \
	-command "command \"score Rubber\"" \
	-variable radioscoring -value RUBBER
$scoringmenu add radiobutton -label Hearts \
	-command "command \"score Hearts\"" \
	-variable radioscoring -value HEARTS
$scoringmenu add separator
$scoringmenu add radiobutton -label Competitive \
	-command "command competitive" -variable radiocompetitive
$scoringmenu add radiobutton -label Noncompetitive \
	-command "command noncompetitive" -variable radiocompetitive
.menu.bridge entryconfigure 10 -state disabled // disable scoring menu
proc menus_tablehost {b {scoring {}} {competitive {}}} {
    global radiocompetitive radioscoring scoringmenu

    set radioscoring $scoring
    set radiocompetitive $competitive
    if $b {set setting normal} {set setting disabled}
    .menu.bridge entryconfigure 10 -state $setting
    .menu.bridge entryconfigure 11 -state $setting
}    
simple "Deal next hand" deal
.menu.bridge entryconfigure 11 -state disabled // disable deal
simple "Show previous deal" previous
set needbridge_bmenu_entries {0 1 2 3 4 5 6}
set needtable_bmenu_entries {7 8} // for deal and scoring see menus_tablehost
.menu.bridge entryconfigure 12 -state disabled // initially, no previous deal
proc menus_enable_previous {} { .menu.bridge entryconfigure 12 -state normal }

// options menu //////////////////////////////////////////////////////////////

set m [menu .menu.options -tearoff no]
.menu add cascade -menu $m -label Options -underline 0

$m add checkbutton -label "Separate talk window" -command {command "separateTalk $separateTalk_"} -variable separateTalk_
$m add checkbutton -label "Hide matrix during auction" -command {command "hideMatrix $hideMatrix_"} -variable hideMatrix_
$m add checkbutton -label "Hide Command Line" -command {command "hideCommandLine $hideCommandLine_"} -variable hideCommandLine_
$m add checkbutton -label "Buttons for bidding" -command {command "bidButtons $bidButtons_"} -variable bidButtons_
$m add checkbutton -label "Beep at my turn" -command {command "beepAtMyTurn $beepAtMyTurn_"} -variable beepAtMyTurn_
$m add checkbutton -label "Deiconify if I'm beeped" -command {command "deiconifyIfBeeped $deiconifyIfBeeped_"} -variable deiconifyIfBeeped_
rcascade "Hide Auction" auction_hide_time \
			{{"after first trick" "hideAuction -1" -1}
			 {"end of auction + 5 seconds" "hideAuction 5" 5}
			 {"end of auction + 10 seconds" "hideAuction 10" 10}}

$m add separator
$m add command -label "Bridge Font" -state disabled
tryset radiofont Medium
$m add radiobutton -label "Large" -command "command \"font large\"" -variable radiofont
$m add radiobutton -label "Medium" -command "command \"font medium\"" -variable radiofont
$m add radiobutton -label "Small" -command "command \"font small\"" -variable radiofont

$m add separator
tryset radiotalkfont Medium
// radiotalkfont is initialized in floater.TCL.
$m add command -label "Talk Font" -state disabled
$m add radiobutton -label "Extra Large" -command "command \"talkfont extralarge\"" -variable radiotalkfont
$m add radiobutton -label "Large" -command "command \"talkfont large\"" -variable radiotalkfont
$m add radiobutton -label "Medium" -command "command \"talkfont medium\"" -variable radiotalkfont
$m add radiobutton -label "Small" -command "command \"talkfont small\"" -variable radiotalkfont
$m add radiobutton -label "Fixed18" -command "command \"talkfont fixed18\"" -variable radiotalkfont
$m add radiobutton -label "Fixed14" -command "command \"talkfont fixed14\"" -variable radiotalkfont
$m add radiobutton -label "Fixed12" -command "command \"talkfont fixed12\"" -variable radiotalkfont

// help menu //////////////////////////////////////////////////////////////

set m [menu .menu.help -tearoff no]
.menu add cascade -menu $m -label Help -underline 0

simple "Introduction" help
// $m add separator

proc prevchar {c} {
    scan $c %c i
    format %c [incr i -1]
}

proc menus_helpcommands {commands} {
    global m help_texts

    set m .menu.help
    set endchars \[fq\]
    set begin a
    foreach s $commands {
	if {![string match "*(*" $s] && ![string match "*)*" $s]} {
	    if {[regexp $endchars [set first [string range $s 0 0]]] &&
	    ![info exists doneit($first)]} {
		set doneit($first) 1
		cascade "$begin-[prevchar $first]" $w
		set begin $first
		set w {}
	    }
	    lappend w "$s \"help $s\""
	}
    }
    if {$w != {}} {cascade $begin-z $w}

    $m add separator
    foreach text $help_texts {
	simple $text
    }
}

// The below assumes "Accept claim" and "Reject claim" are entries 1 and 2 and
// "Retract claim" is 3.

proc menus_noclaim {} {
    foreach i {1 2 3} {
	.menu.bridge entryconfigure $i -state disabled
    }
}

proc menus_defclaim {} {
    foreach i {1 2} {
	.menu.bridge entryconfigure $i -state normal
    }
}

proc menus_declclaim {} {
    .menu.bridge entryconfigure 3 -state normal
}

/////////////////////////////////////////////////////////////////////////////

// n is which entry to modify (# of tricks); setting is 1 or 0
proc claimable {n setting} {
    global claimmenu

    set n [expr 13 - $n]
    if $setting {set setting normal} {set setting disabled}
    $claimmenu entryconfigure $n -state $setting
}

// a claim for n tricks total
proc GUIclaim {n} {
    global contract_tricks

//    puts "GUIclaim $n"
    if ![info exists contract_tricks] return
    if {$n >= $contract_tricks} {
	command "make [expr $n - 6]"
    } else {
	command "down [expr $contract_tricks - $n]"
    }
}

proc update_claimmenu {decltricks deftricks} {
//  talkmsg "update_claimmenu $decltricks $deftricks"
    set max [expr 13 - $deftricks]
    for {set i 0} {$i <= 13} {incr i} {
	if {$i < $decltricks || $i > $max} {
	    claimable $i 0
	} else {
	    claimable $i 1
	}
    }
}    

// if I am declarer, enable claim menu option; otherwise disable
proc menus_declaring {b} {
    if $b {set setting normal} {set setting disabled}
    .menu.bridge entryconfigure 0 -state $setting
}

/////////////////////////////////////////////////////////////////////////////

set bridge_menus_state 1 // normally 0 or 1

proc activate_bridge_menus {b} {
    global bridge_menus_state needbridge_bmenu_entries

    if {$b == $bridge_menus_state} return
    
    if [set bridge_menus_state $b] {set setting normal} {set setting disabled}
    foreach n $needbridge_bmenu_entries {
	.menu.bridge entryconfigure $n -state $setting
    }
//    for {set i 0} {$i <= 13} {incr i} {claimable $i $bridge_menus_state}
}

proc menus_newhand {} {
    activate_bridge_menus 1
    menus_noclaim
    menus_declaring 0
}

proc menus_nobridge {} {activate_bridge_menus 0; menus_noclaim}

menus_nobridge


set seated_menus_state 1

proc activate_seated_menus {b} {
    global seated_menus_state needseated_fmenu_entries

    if {$b == $seated_menus_state} return
    
    if [set seated_menus_state $b] {set setting normal} {set setting disabled}
    foreach n $needseated_fmenu_entries {
	// .menu.file.m entryconfigure $n -state $setting
	.menu.file entryconfigure $n -state $setting
    }
    if !$b {menus_noclaim; menus_declaring 0}
}

activate_seated_menus 0


set table_menus_state 1

proc activate_table_menus {b} {
    global table_menus_state needtable_bmenu_entries needtable_tmenu_entries

    if {$b == $table_menus_state} return
    if !$b {activate_seated_menus 0; menus_tablehost 0}
    
    if [set table_menus_state $b] {set setting normal} {set setting disabled}
    foreach n $needtable_bmenu_entries {
	.menu.bridge entryconfigure $n -state $setting
    }
    foreach n $needtable_tmenu_entries {
	.menu.table entryconfigure $n -state $setting
    }
}

activate_table_menus 0
