/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#ifndef __FLOATER_H__
#define __FLOATER_H__

#define FLOATER_VERSION "8" /* 1.2 */

/* semistatic is used for variables that should be considered static,
   but really aren't because they need to be accessed from bug.c.  They
   should never be accessed from anywhere else. */
#define semistatic

#define FLOATER_MAXNAME 30
#define MAX_OUTPUTNAME_LENGTH 15
#define MAXADDRLEN 80
#define MAXPORTLEN 10

/* to make Solaris happy, string.h must be before curses.h */
#include <string.h>
extern char *index(const char *, int);

#ifdef VOID
#undef VOID
#endif

#ifndef GUI_ONLY
#define GUI_ONLY 0
#endif

/* set RESULTMERCHANT to 1 iff (RESULTSERVER or RES2HTML) */
#ifdef RESULTSERVER
#define RESULTMERCHANT 1
#else
#ifdef RES2HTML
#define RESULTMERCHANT 1
#else
#define RESULTMERCHANT 0
#endif
#endif

/* if LOGINSERVER or RESULTMERCHANT or PSEUDOMAILER, define SERVER to be 1;
   otherwise leave SERVER undef. */
#ifdef LOGINSERVER
#define SERVER 1
#else
#if RESULTMERCHANT
#define SERVER 1
#else
#ifdef PSEUDOMAILER
#define SERVER 1
#endif
#endif
#endif

#ifdef SERVER
#define SILENT SERVER
#else
#define SILENT 0
#endif

#if !GUI_ONLY && !SILENT
#include <curses.h>
#endif

/* In the kibitzer tree, do the four players connect in a ring? */
#define LHO_RHO_CONNECTIONS 0

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#ifdef VOID
#undef VOID
#endif
#include <tcl.h>
#include <string.h>
#include <ctype.h>

#define bool floater_bool
typedef int bool;
#ifndef FALSE
#define FALSE ((bool) 0)
#define TRUE ((bool) 1)
#endif

extern bool using_curses;
#define begincurses() (using_curses ? FALSE : (initscr(), using_curses = TRUE))
#define endcurses() (using_curses ? (endwin(), using_curses = FALSE) : TRUE)

#include "debug.h"
#include "rand.h"
#include "stringlist.h"
#include "alloc.h"
#include "UI.h"
#include "bits.h"
#include "util.h"
#include "result.h"
#include "help.h"
#include "tickler.h"

extern Tcl_Interp *interp;
extern char myname[]; /* in comm.c */
extern char myoutputname[]; /* in comm.c */
extern char *platform; /* in main.c */

#define floaterclock() (atoi(TclGet("floaterclock")))

/* ascii to boolean */
#define atob atoi

#ifndef streq
#define streq(a, b) (strcmp((a), (b)) == 0)
#define strneq(a, b, n) (strncmp((a), (b), (n)) == 0)
#define strncaseeq(a, b, n) (strncasecmp((a), (b), (n)) == 0)
#endif

#define DISALLOW_REENTRY() TclDo("defer 1")
#define ALLOW_REENTRY() TclDo("defer -1")

#ifdef NO_X11
#define NO_TK 1
#else
#define NO_TK 0
#endif

#define STRICT_FILESYSTEM_ACCESS 1

extern bool usingTk;

#if SILENT||NO_TK
#define hasWindows (0)
#else
#if GUI_ONLY
#define hasWindows (1)
#else
#define hasWindows (usingTk)
#endif
#endif

#include "text.h"

#endif
