/*
 * @(#)$Id$
 */
#ifndef	_hzb5_h_
#define	_hzb5_h_

#define		HZ_ESC		'~'

#define		HZ_SI		'}'

#define		HZ_SO_B5_1	'1'
#define		HZ_SO_B5_2	'2'
#define		HZ_SO_HZ	'{'

#define		HZ_B5_LS1	HZ_SO_B5_1
#define		HZ_B5_LS2	HZ_SO_B5_2
#define		HZ_HZ_LS1	HZ_SO_HZ

#define		MODE_SO_ASC	0
#define		MODE_SO_B5_1	1
#define		MODE_SO_B5_2	2
#define		MODE_SO_HZ	3

/* other encoding schemes */

#define		ESC	033		/* 0x2b */
#define		SO	016		/* 0x0e */
#define		SI	017		/* 0x0f */
#define		ALE_LANG	HLE	/* default character set for
					   Chinese (T) */
#define		HLE	'0'		/* Chinese/Taiwan */
#define		CLE	'A'		/* Chinese/Mainland */
#define		JLE	'B'		/* Japanese */
#define		KLE	'C'		/* Korean */

#define		CNS_SS2	0x4e		/* ESC 'N' -- to 2nd plane */
#define		CNS_SS3	0x4f		/* ESC 'O' */

#define		EUC_SS2	0x8e		/* EUC_SS2 0xa2-b0 for plane 2-16  */
#define		EUC_SS3	0x8f

#define	within(lo,x,hi)	(lo<=x&&x<=hi)

#define	b5cvt(hi,lo,h0,h1,l0,l1,hop,lop)		\
							\
	if ( within(h0,hi,h1) && within(l0,lo,l1) ) {	\
		hi hop;					\
		lo lop;					\
		return;					\
	}

#endif
/*
 * History:
 *
 * $Log$
 */
