#!/bin/csh
#                        1         2     3       4        5      6      7
#	LAMA_logos.csh <blocks1> <ac1> <pos1> <blocks2> <ac2> <pos2> <width>
#   Executed by htmlize_LAMA.c which is executed by LAMA_searcher.c
#
#  The files makelogob, colors, marks, wave and default.amino.frq must be in
#  the current directory

unalias rm
limit coredumpsize 1k

set TMP = ../tmp
set BIN = "."
set DNAME = "$$"
set ALIGNLOGOS = "$BIN/align_two_logos.csh"
setenv GS_LIB /opt/sfw/share/ghostscript
setenv LD_LIBRARY_PATH /usr/openwin/lib:/usr/dt/lib:/usr/lib:/usr/ucblib:/opt/sfw/lib:/usr/local/lib

set path = ($path /opt/sfw/bin)



#>>>> where is the 55 limit used???  matrix_logob? <<<<
if ($3 > 55 || $6 > 55) then
   echo "Content-type: text/html"
   echo ""

   echo "<TITLE>LAMA logos alignment error</TITLE>"
   echo "<H3>LAMA logos alignment error</H3>"
   echo "At present logos alignment is only shown for regions in the first 55 positions of the blocks. Sorry."
   exit 1
endif


# make logo of first block - creates files logo.1$$, symvec.1$$, etc.
# Compute character width in matrix_logob so it is the same for both
# Really need the exact block widths here ...
if ($3 > $6) then
   @ maxwidth = ($3 + $7)
else
   @ maxwidth = ($6 + $7)
endif
if ( $maxwidth < 55) then
   @ maxwidth = 55
endif
#echo $maxwidth

set DB = $1
set BLKNAME = $2
$BIN/blimps-bin/matrix_logob $DB $BLKNAME 1$DNAME $maxwidth > /dev/null

# make logo of second block

set DB = $4
set BLKNAME = $5
$BIN/blimps-bin/matrix_logob $DB $BLKNAME 2$DNAME $maxwidth > /dev/null

# pass logo files to align_two_logos so that their offset will be positive 

if ($3 > $6) then
   @ offset =  ($3 - $6)
   $ALIGNLOGOS logo.1$DNAME logo.2$DNAME $offset > $TMP/$$.ps
else
   @ offset = ($6 - $3)
   $ALIGNLOGOS logo.2$DNAME logo.1$DNAME $offset > $TMP/$$.ps
endif

rm logo.[1-2]$DNAME symvec.[1-2]$DNAME makelogop.[1-2]$DNAME colors.[1-2]$DNAME

if ( ! (-e $TMP/$$.ps) ) then
   echo "Content-type: text/html"
   echo ""
   echo "<TITLE>LAMA logos alignment error</TITLE>"
   echo "<H3>LAMA logos alignment error</H3>"
else
   convert $TMP/$$.ps $TMP/$$.gif
   if ( -e $TMP/$$.gif ) then
      echo "Content-type: image/gif"
      echo ""
      cat $TMP/$$.gif
#     rm $TMP/$$.gif
   else
      echo "Content-type: application/postscript"
      echo ""
      cat $TMP/$$.ps
   endif
#  rm $TMP/$$.ps
endif

exit 0



