/**********************************************************************
zyGrib: meteorological GRIB file viewer
Copyright (C) 2008-2010 - Jacques Zaninetti - http://www.zygrib.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

#include "Util.h" 
#include "MblueReader.h" 

//-------------------------------------------------------------------
MblueReader::MblueReader (const std::string fname)
{
	if (fname != "") {
		ok = true;
		openFile (fname);
	}
	else
		ok = false;
}

//-------------------------------------------------------------------
void  MblueReader::openFile (const std::string fname)
{
	DBG("MblueReader::loadFile '%s'", fname.c_str());
	fileName = fname;
	fileSize = zu_filesize_name (fname.c_str());
	
	setAllDates.clear ();
	Util::cleanListPointers (listRecords);
	
	MblueRecord *rec;
	int nbrecords = 0;
	bool go;
	ZUFILE *file = zu_open (fname.c_str(), "rb");
	if (file)
	{
		go = true;
		while (go)
		{
			rec = new MblueRecord (file);
			assert (rec);
			if (rec->isOk()) {
				setAllDates.insert (rec->getRecordCurrentDate());
				
				setAllDataCode.insert ( DataCode(GRB_WIND_VX,LV_ABOV_GND,10) );
				setAllDataCode.insert ( DataCode(GRB_WIND_VY,LV_ABOV_GND,10) );
				setAllDataCode.insert ( DataCode(GRB_WIND_XY2D,LV_ABOV_GND,10) );
				
				DBG("TODO: insert list of DataCodes");
				
				listRecords.push_back (rec);
				nbrecords ++;
				DBG("nbrecords=%d", nbrecords);
			}
			else {
				delete rec;
				go = false;
			}
		}
		
		zu_close (file);
	}
	else {
		ok = false;
	}
	
	if (setAllDates.size() == 0) {
			ok = false;
	}
}
//---------------------------------------------------------------------------
MblueRecord *  MblueReader::getMblueRecord (time_t date)
{
	std::list<MblueRecord *>::iterator it;
	MblueRecord *rec = NULL;
	
	for (it=listRecords.begin(); rec==NULL && it!=listRecords.end(); it++)
	{
		MblueRecord *rtmp = *it;
		if (rtmp->getRecordCurrentDate() == date)
			rec = rtmp;
	}
	return rec;
}
//---------------------------------------------------------------------------
GriddedRecord * MblueReader::getRecord (DataCode dtc, time_t date)
{
	if (MbluePoint::getDataIndex (dtc) >= 0)
		return getMblueRecord (date);
	else
		return NULL;
}

//---------------------------------------------------------------------------
GriddedRecord * MblueReader::getFirstRecord()
{
	if (listRecords.size() > 0)
		return *(listRecords.begin());
	else
		return NULL;
}

//---------------------------------------------------------------------------
double  MblueReader::getDateInterpolatedValue (
							DataCode dtc, double px, double py, time_t date)
{
	MblueRecord *rec = getMblueRecord (date);
	if (rec == NULL) {
		return GRIB_NOTDEF;
	}
	else
		return rec->getInterpolatedValue (dtc, px, py);
}

//-------------------------------------------------------------------
bool MblueReader::getZoneExtension (
			 double *x0,double *y0, double *x1,double *y1)
{
	MblueRecord *rec = *listRecords.begin();
	if (rec && rec->isOk()) {
		return rec->getZoneExtension (x0,y0, x1,y1);
	}
	else {
		return false;
	}
}


