"""
a simple through-the-web test runner

this is an alternative to using a zeo client or zunit. You can set up
a simple external method to call this and view test results in your
browser or via command-line tool.  Results are not saved anywhere.

If you use the makeSuite below to build your test suites, you can pass
in the live zope context as zunit does. See ZWiki.tests.__init__ for
an example of use.

problems:

tests run wherever we invoke this, and are affected by that
environment

tests are affected by the current user's permissions - same as zunit ?

test activities affect the user's browser session. How does zunit
avoid this ?

"""

# import a more recent copy of pyunit if available
# no effect, try other modules
try:
	from Products.ZWiki.tests import unittest
except ImportError:
	import unittest
	
from cStringIO import StringIO

# as in zunit:
class TestCase (unittest.TestCase):
	def setZopeContext (self, ctx):
		self.ZopeContext = ctx

class TestSuite(unittest.TestSuite):
	def setZopeContext (self, ctx):
		self.ZopeContext = ctx
		for test in self._tests:
			test.setZopeContext (ctx)

def makeSuite(testCaseClass, prefix='test', sortUsing=cmp):
    cases = map(testCaseClass,
                unittest.getTestCaseNames(testCaseClass, prefix, sortUsing))
    return TestSuite(cases)
###
                        

def simpleTestRunner(suite, context=None):
    """
    a simple through-the-web test runner.
    """
    context.REQUEST.RESPONSE.setHeader ('Content-type', 'text/plain')

    if hasattr (suite, 'setZopeContext') and context:
        suite.setZopeContext(context)

    s = StringIO()
    unittest.JUnitTextTestRunner(stream=s).run(suite)
    results = s.getvalue()

#    try:
#        stream = StringAndHttpIO (ctx.REQUEST.RESPONSE)
#    except AttributeError:
#        stream = StringIO()
#    success = unittest.TextTestRunner (stream).run (suite).wasSuccessful()
#    results = stream.getvalue()

    s.close()
    return "<html><body><pre>TEST RESULTS:\n%s</pre></body></html>" % (results)

