###########################################################################
#
# TextIndexNG                The next generation TextIndex for Zope
#
# This software is governed by a license. See
# LICENSE.txt for the terms of this license.
#
###########################################################################

"""
A stupid HTML to Ascii converter

$Id: sgml.py,v 1.5 2004/03/16 10:51:35 ajung Exp $
"""

from types import StringType
from Products.TextIndexNG2.BaseConverter import BaseConverter
from StripTagParser import StripTagParser

class Converter(BaseConverter):

    content_type = ('text/sgml', 'text/xml')
    content_description = "Converter SGML to ASCII"

    def convert(self, doc):
        """Convert html data to raw text"""

        p = StripTagParser()
        p.feed(doc)
        p.close()
        return str(p)

    def convert2(self, doc, encoding, mimetype):
        return self.convert(doc), 'iso-8859-15'
