# -*- coding: utf-8 -*-
## 
## Copyright (C)2005 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""
<docstring de votre module>
"""
__docformat__ = 'restructuredtext'


import httplib, urlparse, urllib, base64, mimetypes, re
import threading, time

from string import join

class WebPublish:
    """
    WebPublish : abstract class
    """
    def __init__(self):
        pass

    def logIn(self):
        pass

    def beforePost(self):
        pass

    def post(self):
        pass

    def afterPost(self):
        pass

    def publish(self, title, description, content, extrafields=[]):
        """
        title: the title of the announce
        description : the description of the announce
        extrafields : a list of any extra fields needed
        TODO : should return something
        """
        self.logIn()
        self.beforePost()
        self.post(title, description, content, extrafields=extrafields)
        self.afterPost()
        print "FINISHED", self.documenturl
        return 1

    # Utilities functions

    def posturl(self, url, fields, files):
        urlparts = urlparse.urlsplit(url)
        return self.post_multipart(urlparts[1], urlparts[2], fields, files)

    def post_multipart(self, host, selector, fields, files):
        """
        Post fields and files to an http host as multipart/form-data.
        fields is a sequence of (name, value) elements for regular form fields.
        files is a sequence of (name, filename, value) elements for data to be uploaded as files
        Return the server's response page.
        """
        content_type, body = self.encode_multipart_formdata(fields, files)
        h = httplib.HTTP(host)
        h.putrequest('POST', selector)
        h.putheader('Cookie',getattr(self,'cookie',''))
        h.putheader('Content-Type', content_type)
        h.putheader('Host', host)
        h.putheader('Content-Length', str(len(body)))
        h.endheaders()
        h.send(body)
        errcode, errmsg, headers = h.getreply()
        return h.file.read()

    def encode_multipart_formdata(self, fields, files):
        """
        fields is a sequence of (name, value) elements for regular form fields.
        files is a sequence of (name, filename, value) elements for data to be uploaded as files
        Return (content_type, body) ready for httplib.HTTP instance
        """
        BOUNDARY = '----------ThIs_Is_tHe_bouNdaRY_$'
        CRLF = '\r\n'
        L = []
        for (key, value) in fields:
            L.append('--' + BOUNDARY)
            L.append('Content-Disposition: form-data; name="%s"' % key)
            L.append('')
            L.append(value)
        for (key, filename, value) in files:
            L.append('--' + BOUNDARY)
            L.append('Content-Disposition: form-data; name="%s"; filename="%s"' % (key, filename))
            L.append('Content-Type: %s' % self.get_content_type(filename))
            L.append('')
            L.append(value)
        L.append('--' + BOUNDARY + '--')
        L.append('')
        body = CRLF.join(L)
        content_type = 'multipart/form-data; boundary=%s' % BOUNDARY
        return content_type, body

    def get_content_type(self, filename):
        return mimetypes.guess_type(filename)[0] or 'application/octet-stream'


class PlonePublish(WebPublish):
    """
    """

    def __init__(self, login, password, baseurl, contenttype='Document'):
        """ Initialize the login cookie and various class attributes """
        self.cookie = urllib.urlencode({
            '__ac': base64.encodestring(login + ':' + password)
        })
        self.baseurl = baseurl
        self.contenttype = contenttype

    def beforePost(self):
        """ Create the document and sets documenturl to the edit form url """
        createurl = self.baseurl + "/createObject"
        up = urlparse.urlparse(createurl)
        conn = httplib.HTTPConnection(up[1])
        conn.putrequest('GET', up[2]+'?type_name=%s'%self.contenttype)
        conn.putheader('Cookie',self.cookie)
        conn.endheaders()
        conn.send('')
        response = conn.getresponse()
        self.documenturl = response.getheader('Location')
        try:
            self.documenturl = re.compile('^(.+?)\?.*$').findall(self.documenturl)[0]
        except:
            print "ERROR in location fetching"
            print response.read()
            raise
        conn.close()

    def post(self,title,description,content, extrafields):
        """ Post the content of the document """
        post_url = self.documenturl
        up = urlparse.urlparse(post_url)
        f = open("test.doc")
        s = f.read()
        return self.posturl(self.documenturl,
            [
                ('id', ''),
                ('title', title),
                ('description', description),
                ('text', content),
                ('text_format', 'html'),
                ('form.submitted', '1'),
                ('form.button.Save', 'Enregistrer'),
            ] + extrafields
            ,[
            ]
            )

    def afterPost(self, ):
        """ Upload a file """
        resplit = re.compile("^(.*/)[^/]+$")
        cws_url = resplit.findall(self.documenturl)[0] + "/attachFile"
        f = open("test.doc")
        s = f.read()
        f.close()
        return self.posturl(
            cws_url,
            [
                ('title', "bloub", ),
            ],
            [
                ('file', 'test.doc', s),
            ],
            )



def test():
    pp = PlonePublish(
        login = "admin",
        password = "secret",
        baseurl = "http://localhost:8080/test/plone/test",
        contenttype = "ExFile",
        )
    pp.publish(
        title = "Mon titre",
        description = "Exemple de description",
        content = "gargl",
        )

n_requests = 100

if __name__ == "__main__":
    # Execute n concurrent requests
    threads = []
    running = []
    for x in range(0, n_requests):
        t = threading.Thread(target = test)
        name = t.getName()
        print "Iteration", x, name
        threads.append(t)
        running.append(name)
        t.start()

    # Now wait for all the threads to terminate
    while 1:
        time.sleep(0.1)
        for t in threads:
            name = t.getName()
            if not name in running:
                continue
            if not t.isAlive():
                running.remove(name)
                print "THREAD %s FINISHED," % name, len(running), "remaining."
        if not len(running):
##            print "FINISHED"
            break
