##parameters=
# -*- coding: utf-8 -*-


selenium = context.portal_selenium
suite = selenium.getSuite()
target_language='en'
suite.setTargetLanguage(target_language)

selenium.addUser(id = 'sampleadmin',fullname='Sample Admin',roles=['Member', 'Manager',])
selenium.addUser(id = 'samplemember',fullname='Sample Member',roles=['Member',])

test_logout = suite.TestLogout()
test_admin_login  = suite.TestLoginPortlet('sampleadmin')
test_member_login  = suite.TestLoginPortlet('samplemember')
test_switch_language = suite.TestSwitchToLanguage()

plone21 = selenium.getPloneVersion() > "2.0.5"

if plone21:
    delete_from_folder = "/folder_delete?paths:list=" + suite.getTest().base + '/'
else:
    delete_from_folder = "/folder_delete?ids:list="

suite.addTests("PloneExFile",
    'Login as Sample Admin',
    test_admin_login,
    test_switch_language,
    'Admin adds PloneExFile',
    suite.open(delete_from_folder + 'ploneexfile'),
    suite.open("/"),
    suite.clickAndWait( "//a[contains(text(),'View')]"),
    suite.open( "/createObject?type_name=PloneExFile"),
    suite.verifyTextPresent("PloneExFile has been created."),
    suite.type("name=id","ploneexfile"),
    suite.clickAndWait("name=form_submit"),
    suite.verifyTextPresent("Please correct the indicated errors."),
    suite.verifyTextPresent("Title is required, please correct."),
    suite.type("name=title","Manual test for file upload"),
    suite.type("name=description","Select the Word document '/PloneExFile/tests/word.doc'."),
    suite.pause(10000), # Manually add a file here, if you like
    suite.clickAndWait("name=form_submit"),
    suite.verifyTextPresent("word.doc"),
    #"Delete Contained File",
    #suite.open("/ploneexfile"),
    #suite.clickAndWait( "//a[contains(text(),'Edit')]"),
    #suite.sele("name=file_delete"),
    #suite.clickAndWait("name=form_submit"),
     )

return suite
