# -*- coding: utf-8 -*-
##Original copyright:
##Migration system for the migration from CMFDefault/Event types to archetypes
##based CMFPloneTypes (http://sf.net/projects/collective/).

##Copyright (c) 2004, Christian Heimes and contributors
##All rights reserved.

##Redistribution and use in source and binary forms, with or without modification,
##are permitted provided that the following conditions are met:

## * Redistributions of source code must retain the above copyright notice, this
##   list of conditions and the following disclaimer.
## * Redistributions in binary form must reproduce the above copyright notice,
##   this list of conditions and the following disclaimer in the documentation
##   and/or other materials provided with the distribution.
## * Neither the name of the author nor the names of its contributors may be used
##   to endorse or promote products derived from this software without specific
##   prior written permission.

## 
## Copyright (C)2005 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

"""Plone ExFile premigration module
"""
__version__ = "$Revision: 1.6 $"
# $Source: /cvsroot/ingeniweb/PloneExFile/migration/PreMigrator.py,v $
# $Id: PreMigrator.py,v 1.6 2006/03/07 15:51:47 encolpe Exp $
__docformat__ = 'restructuredtext'

from copy import copy

# Python imports
from StringIO import StringIO
import sys

# Zope imports
from OFS.Image import File
from Acquisition import aq_base
from Acquisition import aq_parent
from Acquisition import aq_inner
from DateTime import DateTime
from Persistence import PersistentMapping

# Archetypes imports
from Products.Archetypes.interfaces.base import IBaseUnit

# CMF imports
from Products.CMFCore.utils import getToolByName

class ZAttachmentAttribute:
    """Fake ZAttachmentAttribute class. Used to get attachment"""
    __underlyingFile__ = None
    title = ''
    filename = ''
    content_type = ''
    
class ZDummyAttachment:
    """Fake ZDummyAttachment class. Used to get attachment data"""
    content = ''

def copyPermMap(old):
    """bullet proof copy
    """
    new = PersistentMapping()
    for k,v in old.items():
        nk = copy(k)
        nv = copy(v)
        new[k] = v
    return new

class Migrator:
    """Migration class
    """

    def migrateToFile(self, portal, exfile_brains, stdout, options):
        """Migrate PloneExFile 2.x to File
        """

        dry_run = options.get('dry_run', False)
        limit = options.get('convert_limit', 0)

        if stdout is not None:
            stdout.write('Migrate PloneExFile v2.x to File.\r\n')
        
        nb_exfiles = 0
        already = 0
        
        # If we have a 'limit' option set, we just try to convert <limit> exfiles maximum.
        # This is so just to avoid Memory Errors.
        if limit:
            limit = min(len(exfile_brains), limit)
        else:
            limit = len(exfile_brains)

        stdout.write("There are %d PloneExFile objects.\r\n" % len(exfile_brains))
        stdout.write("Migrating at most %d files.\r\n" % limit)

        # Get all PloneExFile in v2.x
        for exfile_brain in exfile_brains:
            exfile = exfile_brain.getObject()
            
            # We fetch the important dates before anything else
            creation_date = DateTime(exfile.CreationDate())
            modification_date = DateTime(exfile.ModificationDate())

            # Check limit
            if nb_exfiles >= limit:
                break

            # Check if it has not been done before
            if not getattr(exfile, 'attach', None):
                already += 1
                continue

            # This is an exfile from v2.x
            parent = exfile.getParentNode()
            nb_exfiles += 1

            # Dry run means we simulate
            if not dry_run:
                # Migrate attachment
                stdout.write('  ...migrating exfile attachment...\r\n')
                
                attachment = exfile.attach
                content_type = attachment.content_type
                title = attachment.title
                attachment_file = attachment.__underlyingFile__
                data = attachment_file.content
                new_file = File('new_file', title, data, content_type)
                def read(self):
                    return self.data
                File.read=read
                
                setattr(new_file, 'filename', attachment.filename)
                setattr(new_file, 'headers', {'Content-Type':content_type})
                
                new_id = 'exfile_' + exfile.getId()
                
                # If we try the migration several times, this can be in the way
                if new_id in parent.objectIds():
                    parent.manage_delObjects([new_id])
                
                parent.invokeFactory('File', new_id, title=exfile.Title())
                newfile = getattr(parent, new_id)
                newfile.setDescription(exfile.Description())
                newfile.update_data(new_file.data, content_type, len(new_file.data))
                # XXX Ugly hack: Uses the files alt property to store filename
                newfile.alt=attachment.filename
                #newfile.manage_edit(title, content_type, filedata=new_file)
                # We have to set the Owner
                # getWrappedOwner is not always available
                if hasattr(aq_base(exfile), 'getWrappedOwner'):
                    owner = exfile.getWrappedOwner()
                    newfile.changeOwnership(owner)
                else:
                    newfile._owner = exfile.getOwner(info = 1)

                # We have to take care of the workflow state
                wfh = getattr(exfile, 'workflow_history', None)
                if wfh:
                    wfh = copyPermMap(wfh)
                    newfile.workflow_history = wfh

                # We have to keep the creation and modification date
                newfile.creation_date = creation_date
                newfile.setModificationDate(modification_date)

                # Try to remove the article from live memory
                exfile = None
            
        if stdout is not None:
            stdout.write('%s exfile(s) migrated.\r\n' % nb_exfiles)
            stdout.write('%s exfile(s) were already migrated.\r\n' % already)
            stdout.write('Migration from PloneExFile v2.x to v3.x finished.\r\n')
        return stdout.getvalue()


def migrate(self):
    out = StringIO()
    migrator = Migrator()
    cat_tool = getToolByName(self, 'portal_catalog')
    exfile_brains = cat_tool(portal_type='ExFile')
    result =migrator.migrateToFile(self, exfile_brains, out, options={})
    exfile_brains = None
    return result
