# -*- coding: utf-8 -*-
## 
## Copyright (C)2005 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

"""
$Id: Install.py,v 1.17 2006/03/03 10:17:51 el_gringo Exp $
"""
__docformat__ = 'restructuredtext'



__author__  = ''

# Python imports
from StringIO import StringIO

# Zope imports
from Products.ExternalMethod.ExternalMethod import ExternalMethod, manage_addExternalMethod
from Products.StandardCacheManagers import RAMCacheManager

# CMF imports
from Products.CMFCore.utils import getToolByName

# Archetypes imports
from Products.Archetypes import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin

# Products imports
from Products.PloneExFile.config import PROJECTNAME, GLOBALS, SKINS_DIR, \
     HAS_PLONE_2_1


def install(self):
    out = StringIO()
    
    # Install types
    typeInfo = listTypes(PROJECTNAME)
    installTypes(self, out,
                 typeInfo,
                 PROJECTNAME)

    # Install skin
    install_subskin(self, out, GLOBALS)
    if not HAS_PLONE_2_1:
        # removes plone 2.1 specific templates from layers
        skinstool = getToolByName(self, 'portal_skins')
        for skinname in skinstool.getSkinSelections():
            path = skinstool.getSkinPath(skinname)
            
            path = [i.strip() for i in path.split(',')
                    if i != 'ploneexfile_plone21' ]
            
            path = ','.join(path)
            skinstool.addSkinSelection(skinname, path)
    
    # Register templates
    registerTemplates(self, typeInfo, out)
    
    # Install properties
    ptool = getToolByName(self, 'portal_properties')
    
    # Create property sheets
    if not hasattr(ptool, 'ploneexfile_properties'):
        ptool.addPropertySheet('ploneexfile_properties', 'PloneExFile properties')
    
    # Create PloneExFile properties
    props = ptool.ploneexfile_properties
    
    if not hasattr(props, 'use_lock'):
        props._setProperty('use_lock', 0, 'boolean')
    
    if not hasattr(props, 'show_smallpreview'):    
        props._setProperty('show_smallpreview', 0, 'boolean')
    
    # Add action icons
    addActionIcon(self,
                  category='plone',
                  action_id='unlock_lock',
                  icon_expr='lock.gif',
                  title="Lock (Currently not locked)",
                  priority=0)
    addActionIcon(self,
                  category='plone',
                  action_id='lock_unlock',
                  icon_expr='unlock.gif',
                  title="Unlock (Currently locked)",
                  priority=0)

    provider = getToolByName(self, 'portal_selenium', None)
    if provider:
        # Functional Tests
        action = {'id':PROJECTNAME.lower(),
                  'name':PROJECTNAME,
                  'action':'string:here/get_%s_ftests'%PROJECTNAME.lower(),
                  'condition': '',
                  'permission': 'View',
                  'category':'Products',
                  'visible': 1}
        provider.addAction(**action)

    out.write('Installation completed.\n')
    return out.getvalue()

def uninstall(self):
    out = StringIO()
    
    out.write('Uninstallation completed.\n')
    return out.getvalue()
    
def addActionIcon(self, category, action_id, icon_expr, title=None, priority=0):
    # Add the action icon if and only if it's not already here
    ai=getToolByName(self, 'portal_actionicons')
    if ai.queryActionInfo( category, action_id ):
      ai.updateActionIcon(category, action_id, icon_expr, title, priority)
    else:
      ai.addActionIcon(category, action_id, icon_expr, title, priority)

def registerTemplates(self, typeInfo, out):
    """Registers templates in the archetypes tool
    """
    for t in typeInfo:
        klass          = t['klass']
        portal_type    = klass.portal_type
        registerTemplatesForClass(self, klass, portal_type)

def registerTemplatesForClass(self, klass, portal_type):
    atTool       = getToolByName(self, 'archetype_tool')
    default_view = getattr(klass, 'default_view', 'base_view')
    suppl_views  = getattr(klass, 'suppl_views', ())
    views        = ['base_view',]

    if default_view != 'base_view':
        atTool.registerTemplate(default_view)
        views.append(default_view)

    for view in suppl_views:
        atTool.registerTemplate(view)
        views.append(view)

    atTool.bindTemplate(portal_type, views)
