import unittest

from Products.ParsedXML.tests import test_dom
from Products.ParsedXML.tests import test_wrappeddom
from Products.ParsedXML.tests import test_printer
from Products.ParsedXML.tests import test_parser
from Products.ParsedXML.tests import test_persistence
from Products.ParsedXML.tests import test_truthable
from Products.ParsedXML.tests import test_acquisition
from Products.ParsedXML.tests import test_aqpain
from Products.ParsedXML.tests import test_zopeinterface
from Products.ParsedXML.tests import test_collection
from Products.ParsedXML.tests import test_ODB

def test_suite():
    suite = unittest.TestSuite()
    suite.addTest(test_dom.test_suite())
    suite.addTest(test_wrappeddom.test_suite())
    suite.addTest(test_printer.test_suite())
    suite.addTest(test_parser.test_suite())
    suite.addTest(test_persistence.test_suite())
    suite.addTest(test_truthable.test_suite())
    suite.addTest(test_acquisition.test_suite())
    suite.addTest(test_aqpain.test_suite())
    suite.addTest(test_zopeinterface.test_suite())
    suite.addTest(test_collection.test_suite())
    suite.addTest(test_ODB.test_suite())
    return suite

def main():
    if hasattr(unittest, 'JUnitTextTestRunner'):
        unittest.JUnitTextTestRunner().run(test_suite())
    else:
        unittest.TextTestRunner(verbosity=0).run(test_suite())

if __name__ == '__main__':
    main()




