import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Products.Archetypes.tests.test_interfaces import InterfaceTest
from Products.CMFMember.config import *
from Products.CMFMember.content import member
from Products.CMFMember.interfaces.member import IMember, IMemberPlone
from types import TupleType
from Interface.Implements import getImplementsOfInstances, \
         getImplements, flattenInterfaces
from Interface.Verify import verifyClass, verifyObject
from Interface.Exceptions import BrokenImplementation, DoesNotImplement
from Interface.Exceptions import BrokenMethodImplementation
from Products.Archetypes.public import registerType

def className(klass):
    """ get the short class name """
    # remove <>
    name = str(klass)[1:-1]
    return name.split('.')[-1].split(' ')[0]


class M(member.Member):pass
registerType(M, PKG_NAME)

class FM(member.FolderishMember):pass
registerType(FM, PKG_NAME)

testInstances = (
    ( M('test'),()),
    ( FM('test'), ())
    )

tests = []

for testInstance in testInstances:
    instance, forcedImpl = testInstance
    name = className(instance.__class__)
    funcName = 'test%sInterface' % name

    class InstanceInterfaceTest(InterfaceTest):
        """ implementation for %s """ % name
        instance   = instance
        forcedImpl = forcedImpl

    # add the testing method to the class to get a nice name
    setattr(InstanceInterfaceTest, funcName, lambda self: self._testStuff())
    tests.append(InstanceInterfaceTest)

                
if __name__ == '__main__':
    framework(verbosity=1)
else:
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    for test in tests:
        suite.addTest(makeSuite(test))

                
