import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Products.CMFMember.tests import CMFMemberTestCase
from Products.CMFCore.utils import getToolByName
from Interface.Verify import verifyClass
from AccessControl.SecurityManagement import newSecurityManager

import Products.CMFMember
from Products.CMFMember.tools.memberdatacontainer import MemberDataContainer

allowed_types = ('Member',)

class TestMemberDataContainer(CMFMemberTestCase.CMFMemberTestCase):
    def testAddNewMemberAndPruneOrphans(self):
        self.membership.addMember('orphanSoon', 'secret',['Member'],[])
        noMembers = self.memberdata.getMemberDataContents()[0]
        noMember = noMembers['member_count']
        noOrphans = noMembers['orphan_count']
        self.assertEqual(noOrphans, 0)
        self.memberdata.pruneMemberDataContents()
        noMembers = self.memberdata.getMemberDataContents()[0]
        self.assertEqual(noMembers['orphan_count'], 0)

    def testDeleteUserInAclUsersAndPruneOrphans(self):

        #set an email to have a Member object created
        
        tmpUser = self.membership.getMemberById(self.portal_user_info['id'])
        self.failUnless(tmpUser)
        tmpUser.setMemberProperties({'email': 'foo@bar.com'})

        #check that we don't have any orphans before we begin

        noMembers = self.memberdata.getMemberDataContents()[0]
        self.failIf(noMembers['member_count'] == 0)
        self.assertEqual(noMembers['orphan_count'], 0)

        #delete the user in acl_users and check if we have one orphan

        self.portal.acl_users.__class__.userFolderDelUsers(self.portal.acl_users,
                                                           (self.portal_user_info['id'],))
        noMembers = self.memberdata.getMemberDataContents()[0]
        self.assertEqual(noMembers['orphan_count'], 1)

        #remove orphans and check that no are left

        self.memberdata.pruneMemberDataContents()
        noMembers = self.memberdata.getMemberDataContents()[0]
        self.assertEqual(noMembers['orphan_count'], 0)

    def testAllowedMemberTypesInstanceDefault(self):
        for memberType in self.memberdata.allowedContentTypes():
            self.failIf(not memberType.getId() in self.memberdata.allowed_content_types)

    def ftestAllowedMemberTypesInstanceChanged(self):

        # check that everything is ok before we change
        self.assertEqual(list(self.memberdata.getAllowedMemberTypes()),
                        ['Member'])

        memberdataType = getToolByName(self.portal, 'portal_types').MemberDataContainer
        self.assertEqual(memberdataType.allowed_content_types, allowed_types)

        # change and compare to the type and local instance
        self.memberdata.setAllowedMemberTypes(('Member1','Member2',))

        pt_allowed = self.portal.portal_types.MemberDataContainer.getProperty('allowed_content_types')

        # check that portal_type is set
        self.assertEqual(pt_allowed, ('Member1','Member2',))

        # check member types for instance 
        self.assertEqual(list(self.memberdata.getAllowedMemberTypes()),
                        ['Member1','Member2'])
                        
    def testFolderContentsTabRemoval(self):
    
        # the PortalMemberdata Container doesn't need a Folder Contents tab;
        # the view tab's action is folder_contents, so we remove it.
        fc_types = getToolByName(self.portal, 'portal_properties').site_properties.use_folder_tabs
        self.failIf('MemberDataContainer' in fc_types, 'MDC Still in use_folder_tabs Types List: %s' % (fc_types,))

    def testTestContentsValues(self):
        orig_value = len(self.memberdata.contentValues())
        howmany = 10
        self.addTestMembers(howmany)
        self.assertEqual(len(self.memberdata.contentValues()),
                         howmany + orig_value)
        # make half of the users private
        wf = getToolByName(self.portal, 'portal_workflow')
        members = self.memberdata.contentValues()
        for member in members[0:howmany/2]:
            wf.doActionFor(member, 'make_private')
        # check if we only got the public users back 
        newSecurityManager(None, self.portal_user)
        self.assertEqual(len(self.memberdata.contentValues()),
                         howmany/2 + orig_value)
        

if __name__ == '__main__':
    import profile
    profile.run('framework(verbosity=1)','profiler')
    import pstats
    p = pstats.Stats('profiler')
    p.sort_stats('cum').print_stats('memberdata')
    
else:
    from unittest import TestSuite, makeSuite
    def test_suite():
        suite = TestSuite()
        suite.addTest(makeSuite(TestMemberDataContainer))
        return suite

