import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Products.CMFMember.tests import CMFMemberTestCase
from Products.CMFMember.setup.import_members import importUsers
from Products.CMFMember.config import HOMEDIR

import_user_ids = ('test1', 'test2', 'test3')

class TestImport(CMFMemberTestCase.CMFMemberTestCase):

    def testSimpleCSVImport(self):
        importUsers(self, self.portal, basedir=os.path.join(HOMEDIR, 'tests'))
        mbr=dict([(x.id, x) for x in self.portal.portal_memberdata.objectValues()])
        self.assertEqual('public', self.portal.portal_workflow.getInfoFor( mbr['test1'], 'review_state') )
        for user_id in import_user_ids:
            self.failUnless(mbr.has_key(user_id))
        self.failUnless( "No portrait written", mbr['test1'].getRawPortrait() )

    def testOverwriteCSVImport(self):
        importUsers(self, self.portal, basedir=os.path.join(HOMEDIR, 'tests'))
        importUsers(self, self.portal, basedir=os.path.join(HOMEDIR, 'tests'), overwrite=True)
        
        mbr=dict([(x.id, x) for x in self.portal.portal_memberdata.objectValues()])
        self.assertEqual('public', self.portal.portal_workflow.getInfoFor( mbr['test1'], 'review_state') )
        for user_id in import_user_ids:
            self.failUnless(mbr.has_key(user_id))
        self.failUnless( "No portrait written", mbr['test1'].getRawPortrait() )
        

if __name__ == '__main__':
    framework(verbosity=1)
else:
    from unittest import TestSuite, makeSuite
    def test_suite():
        suite = TestSuite()
        suite.addTest(makeSuite(TestImport))
        return suite
