##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Manual reference class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View

from Products.Archetypes.public import registerType
from Products.Archetypes.public import Schema
from Products.Archetypes.public import StringField, StringWidget

from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema
from Products.CMFBibliographyAT.content.fields \
    import organizationField, addressField, editionField


SourceSchema = Schema((
    organizationField,
    addressField,
    editionField,
     ))

ManualSchema = HeaderSchema + AuthorSchema + CoreSchema +  \
               SourceSchema + TrailingSchema


class ManualReference(BaseEntry):
    """ content type to make reference to a manual.
    """
    archetype_name = "Manual Reference"
    source_fields = ('organization', 'address', 'edition')
    security = ClassSecurityInfo()
    schema = ManualSchema
    
    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default manual source format
        """
        try:
            return self.ManualSource()
        except AttributeError:
            return "Manual."


registerType(ManualReference)
