#ifndef _INCLUDED_GTKLIBRARYTRACKLIST_H_
#define _INCLUDED_GTKLIBRARYTRACKLIST_H_

#include <vector>

#include <time.h>
#include <gdkmm/pixbuf.h>
#include <glibmm/ustring.h>

#include "facontext.h"
#include "playlist.h"
#include "gtklibrary.h"
#include "gtklibrarylist.h"
#include "error.h"
#include "event.h"

class GTKLibrary::GTKTrackList : public GTKLibraryList {
 public:
	GTKTrackList(GTKLibrary *library);
 
 private:
 
	//Internal Functions
	virtual void set_list_columns();
 	virtual void set_rows_data(std::vector<Gtk::TreeModel::Path> RowPaths);
 
 	virtual void init_row(Gtk::TreeModel::Row& new_row);
 	//Possible Columns
 	class TracksCols : public Gtk::TreeModel::ColumnRecord {
	 public:

		TracksCols()
		{ add(icon); add(track); add(title); add(time); add(album); add(artist); add(comment); add(location); add(genre); add(year); add(last_refresh); }

		Gtk::TreeModelColumn< Glib::RefPtr<Gdk::Pixbuf> > icon;
		Gtk::TreeModelColumn<Glib::ustring> track;
		Gtk::TreeModelColumn<Glib::ustring> title;
		Gtk::TreeModelColumn<Glib::ustring> time;
		Gtk::TreeModelColumn<Glib::ustring> album;
		Gtk::TreeModelColumn<Glib::ustring> artist;
		Gtk::TreeModelColumn<Glib::ustring> comment;
		Gtk::TreeModelColumn<Glib::ustring> location;
		Gtk::TreeModelColumn<Glib::ustring> genre;
		Gtk::TreeModelColumn<Glib::ustring> year;
		Gtk::TreeModelColumn<time_t> last_refresh;
	};

	TracksCols m_TrackCols;
};

#endif
/* arch-tag: 43985433-d3a1-4ebf-9b2c-f7ab4327e774 */
