#line 16 "vector.nw"
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "debug.h"
#include "run.h"
#include "heap.h"
#include "stack.h"
#include "trail.h"
#include "eval.h"
#include "threads.h"
#include "trace.h"
#include "cam.h"

enum { VECTOR_TAG };

static NodeInfo vector_info = {
    VECTOR_TAG, 0, (const int *)0, (Label)eval_whnf, "(,)", (FinalFun)0
};
static struct vector_node empty = {
    &vector_info, vector_node_size(0), { }
};

#line 44 "vector.nw"
DECLARE_ENTRYPOINT(__vinit);

FUNCTION(__vinit)
{
    long i, n;
    Node *init, *vec;

    EXPORT_LABEL(__vinit)
 ENTRY_LABEL(__vinit)
    EVAL_RIGID_INT(__vinit);
    n = int_val(sp[0]);
    if ( n < 0 )
    {
	fprintf(stderr, "vinit: bad length (%ld)\n", n);
	exit(2);
    }

    if ( n == 0 )
	vec = (Node *)&empty;
    else
    {
	CHECK_HEAP(vector_node_size(n));
	init = sp[1];
	while ( is_boxed(init) && is_indir_node(init) )
	    init = init->n.node;
	vec	      = (Node *)hp;
	vec->a.info   = &vector_info;
	vec->a.length = vector_node_size(n);
	for ( i = 0; i < n; i++ )
	    vec->a.args[i] = init;
	hp += vector_node_size(n);
    }

    sp += 2;
    RETURN(vec);
}

#line 87 "vector.nw"
DECLARE_ENTRYPOINT(__vcopy);

FUNCTION(__vcopy)
{
    Node *vec;

    EXPORT_LABEL(__vcopy)
 ENTRY_LABEL(__vcopy)
    EVAL_RIGID(__vcopy);
    ASSERT(node_tag(sp[0]) == VECTOR_TAG);

    /* NB the empty vector is shared and must not be copied */
    vec = sp[0];
    if ( vector_argc(vec) > 0 )
    {
	CHECK_HEAP(vec->a.length);
	vec = (Node *)hp;
	memcpy(vec, sp[0], sp[0]->a.length * word_size);
	hp += vec->a.length;
    }

    sp += 1;
    RETURN(vec);
}

#line 117 "vector.nw"
DECLARE_ENTRYPOINT(__vget);
DECLARE_LABEL(__vget_1);

FUNCTION(__vget)
{
    Node *aux;

    EXPORT_LABEL(__vget)
 ENTRY_LABEL(__vget)
    EVAL_RIGID(__vget);
    ASSERT(node_tag(sp[0]) == VECTOR_TAG);

    aux	  = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__vget_1);
}

static
FUNCTION(__vget_1)
{
    int  i;
    Node *vec, *r;

 ENTRY_LABEL(__vget_1)
    EVAL_RIGID_INT(__vget_1);

    i	= int_val(sp[0]);
    vec = sp[1];
    if ( i < 0 || (unsigned)i >= vector_argc(vec) )
    {
	fprintf(stderr, "vget: index out range (%d)\n", i);
	exit(2);
    }

    r = vec->a.args[i];
    if ( is_boxed(r) )
    {
	*++sp = r;
	GOTO(r->info->eval);
    }
    sp += 2;
    RETURN(r);
}

#line 171 "vector.nw"
DECLARE_ENTRYPOINT(__vset);
DECLARE_LABEL(__vset_1);

FUNCTION(__vset)
{
    Node *aux;

    EXPORT_LABEL(__vset)
 ENTRY_LABEL(__vset)
    EVAL_RIGID(__vset);
    ASSERT(node_tag(sp[0]) == VECTOR_TAG);

    aux	  = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__vset_1);
}

static
FUNCTION(__vset_1)
{
    int  i;
    Node *vec, *node;

 ENTRY_LABEL(__vset_1)
    EVAL_RIGID_INT(__vset_1);

    i	 = int_val(sp[0]);
    vec	 = sp[1];
    node = sp[2];
    sp	+= 3;

    if ( i < 0 || (unsigned)i >= vector_argc(vec) )
    {
	fprintf(stderr, "vset: index out range (%d)\n", i);
	exit(2);
    }

    SAVE(vec, a.args[i]);
    vec->a.args[i] = node;
    RETURN(vec);
}
