#line 13 "int.nw"
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "debug.h"
#include "run.h"
#include "heap.h"
#include "stack.h"
#include "eval.h"
#include "threads.h"
#include "cam.h"
#include "trace.h"

#line 33 "int.nw"
#if ONLY_BOXED_OBJECTS
# define minInt (Node *)&minInt_node
# define maxInt (Node *)&maxInt_node
static struct int_node minInt_node = { &int_info, LONG_MIN };
static struct int_node maxInt_node = { &int_info, LONG_MAX };
#else
# define minInt mk_int(LONG_MIN/2)
# define maxInt mk_int(LONG_MAX/2)
#endif

DECLARE_ENTRYPOINT(__primMinInt);
DECLARE_ENTRYPOINT(__primMaxInt);

FUNCTION(__primMinInt)
{
    EXPORT_LABEL(__primMinInt)
 ENTRY_LABEL(__primMinInt)
    RETURN(minInt);
}

FUNCTION(__primMaxInt)
{
    EXPORT_LABEL(__primMaxInt)
 ENTRY_LABEL(__primMaxInt)
    RETURN(maxInt);
}

#line 67 "int.nw"
DECLARE_ENTRYPOINT(__primAddInt);
DECLARE_LABEL(__primAddInt_1);

FUNCTION(__primAddInt)
{
    Node *aux;

    EXPORT_LABEL(__primAddInt)
 ENTRY_LABEL(__primAddInt)
    EVAL_RIGID_INT(__primAddInt);
    aux   = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__primAddInt_1);
}

static
FUNCTION(__primAddInt_1)
{
#if ONLY_BOXED_OBJECTS
    int  i;
#endif
    Node *r;

 ENTRY_LABEL(__primAddInt_1)
    EVAL_RIGID_INT(__primAddInt_1);
#if ONLY_BOXED_OBJECTS
    i	= int_val(sp[1]) + int_val(sp[0]);
    sp += 2;

    CHECK_HEAP(int_node_size);
    r	    = (Node *)hp;
    r->info = &int_info;
    r->i.i  = i;
    hp	   += int_node_size;
#else
    r	= (Node *)((long)sp[1] + (long)sp[0] - 1);
    sp += 2;
#endif
    RETURN(r);
}


DECLARE_ENTRYPOINT(__primSubInt);
DECLARE_LABEL(__primSubInt_1);

FUNCTION(__primSubInt)
{
    Node *aux;

    EXPORT_LABEL(__primSubInt)
 ENTRY_LABEL(__primSubInt)
    EVAL_RIGID_INT(__primSubInt);
    aux   = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__primSubInt_1);
}

static
FUNCTION(__primSubInt_1)
{
#if ONLY_BOXED_OBJECTS
    int	 i;
#endif
    Node *r;

 ENTRY_LABEL(__primSubInt_1)
    EVAL_RIGID_INT(__primSubInt_1);
#if ONLY_BOXED_OBJECTS
    i	= int_val(sp[1]) - int_val(sp[0]);
    sp += 2;

    CHECK_HEAP(int_node_size);
    r	    = (Node *)hp;
    r->info = &int_info;
    r->i.i  = i;
    hp	   += int_node_size;
#else
    r = (Node *)((long)sp[1] - (long)sp[0] + 1);
    sp += 2;
#endif
    RETURN(r);
}


DECLARE_ENTRYPOINT(__primMulInt);
DECLARE_LABEL(__primMulInt_1);

FUNCTION(__primMulInt)
{
    Node *aux;

    EXPORT_LABEL(__primMulInt)
 ENTRY_LABEL(__primMulInt)
    EVAL_RIGID_INT(__primMulInt);
    aux   = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__primMulInt_1);
}

static
FUNCTION(__primMulInt_1)
{
#if ONLY_BOXED_OBJECTS
    int	 i;
#endif
    Node *r;

 ENTRY_LABEL(__primMulInt_1)
    EVAL_RIGID_INT(__primMulInt_1);
#if ONLY_BOXED_OBJECTS
    i	= int_val(sp[1]) * int_val(sp[0]);
    sp += 2;

    CHECK_HEAP(int_node_size);
    r	    = (Node *)hp;
    r->info = &int_info;
    r->i.i  = i;
    hp	   += int_node_size;
#else
    r = (Node *)(int_val(sp[1]) * ((long)sp[0] - 1) + 1);
    sp += 2;
#endif
    RETURN(r);
}

DECLARE_ENTRYPOINT(__div);
DECLARE_LABEL(__div_1);

FUNCTION(__div)
{
    Node *aux;

    EXPORT_LABEL(__div)
 ENTRY_LABEL(__div)
    EVAL_RIGID_INT(__div);
    aux   = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__div_1);
}

static
FUNCTION(__div_1)
{
    int  i;
    Node *r;

 ENTRY_LABEL(__div_1)
    EVAL_RIGID_INT(__div_1);
    i	= int_val(sp[1]) / int_val(sp[0]);
    sp += 2;

#if ONLY_BOXED_OBJECTS
    CHECK_HEAP(int_node_size);
    r	    = (Node *)hp;
    r->info = &int_info;
    r->i.i  = i;
    hp	   += int_node_size;
#else
    r = mk_int(i);
#endif
    RETURN(r);
}


DECLARE_ENTRYPOINT(__mod);
DECLARE_LABEL(__mod_1);

FUNCTION(__mod)
{
    Node *aux;

    EXPORT_LABEL(__mod)
 ENTRY_LABEL(__mod)
    EVAL_RIGID_INT(__mod);
    aux   = sp[0];
    sp[0] = sp[1];
    sp[1] = aux;
    GOTO(__mod_1);
}

static
FUNCTION(__mod_1)
{
    int  i;
    Node *r;

 ENTRY_LABEL(__mod_1)
    EVAL_RIGID_INT(__mod_1);
    i	= int_val(sp[1]) % int_val(sp[0]);
    sp += 2;

#if ONLY_BOXED_OBJECTS
    CHECK_HEAP(int_node_size);
    r	    = (Node *)hp;
    r->info = &int_info;
    r->i.i  = i;
    hp	   += int_node_size;
#else
    r = mk_int(i);
#endif
    RETURN(r);
}
