% $Id: DictBinding.lhs,v 1.18 2004/09/08 21:54:33 berrueta Exp $
%
% Copyright (c) 2004, Diego Berrueta
% See LICENSE for the full license.
%
\nwfilename{DictBinding.lhs}
\codesection{Dictionary generation}
Type constructors and values generated by imported type classes and
instances do not appear in the interface files, so they must be
generated and entered into the environments.
\begin{lstlisting}

> module DictBinding(bindDict) where
> import TypeClassEnv
> import InstanceEnv
> import TypeConstructorEnv
> import ValueEnv
> import TopEnv
> import Ident
> import DictUtils
> import TypeExpr
> import DualTopEnv
> import TypeTrans
> import Maybe
> import Set
> import TypeInstGen
> import Types
> import TypeExpansion(normalize)
> import List

\end{lstlisting}
Binding transformed entities from imported modules.
\begin{lstlisting}

> bindDict :: TypeClassEnv -> InstanceEnv ->
>             (TCEnv,ValueEnv) -> (TCEnv,ValueEnv)
> bindDict typeClassEnv instEnv (tcEnv,tyEnv) = (tcEnv',tyEnv'')
>   where importedTypeClasses = map snd
>                             $ filter (isQualified . fst)
>                             $ allImports typeClassEnv
>         importedInstances   = map (\(_,_,z) -> z)
>                             $ allImportsDualTopEnv instEnv
>         (tcEnv',tyEnv') = foldr (bindDictTypeClass typeClassEnv) (tcEnv,tyEnv)
>                                 importedTypeClasses
>         tyEnv''         = foldr (bindDictInstance typeClassEnv) tyEnv'
>                                 importedInstances

\end{lstlisting}
\codesubsection{Binding type classes}
\begin{lstlisting}

> bindDictTypeClass :: TypeClassEnv -> TypeClassInfo ->
>                      (TCEnv,ValueEnv) -> (TCEnv,ValueEnv)
> bindDictTypeClass typeClassEnv
>                   (TypeClassInfo typeClass tv superClasses sigEnv)
>                   (tcEnv,tyEnv) =
>   (tcEnv',tyEnv')
>   where tcEnv'  = bindTypeClassData typeClassEnv typeClass tcEnv
>         tyEnv'  = bindTypeClassDataConstr typeClassEnv typeClass
>                 $ bindSelectorFunctions m typeClassEnv typeClass methods
>                 $ bindTraverserFunctions m typeClassEnv typeClass superClasses
>                 $ tyEnv
>         methods = sortMethods sigEnv
>         m = fromJust $ fst $ splitQualIdent typeClass

> bindTypeClassData :: TypeClassEnv -> QualIdent -> TCEnv -> TCEnv
> bindTypeClassData typeClassEnv typeClass =
>   qualBindImportTopEnv m dataId ti
>   where dataQId = dictTypeClassDataQIdent typeClass
>         (Just m,dataId) = splitQualIdent dataQId
>         dataConstrId = dictTypeClassDataConstrIdent (unqualify typeClass)
>         ti = let arity = 1
>                  existsVars = 0
>              in  DataType dataQId arity
>                    [Just (Data (dataConstrId) existsVars tys)]
>         (tyexprWC,tv) = dictTypeClassDataRhs typeClassEnv typeClass
>         tys = typeArguments (toType [tv] (removeTypeExprContext tyexprWC))

> bindTypeClassDataConstr :: TypeClassEnv -> QualIdent -> ValueEnv -> ValueEnv
> bindTypeClassDataConstr typeClassEnv typeClass =
>   qualBindImportTopEnv m dcId vi
>   where dcQId = dictTypeClassDataConstrQIdent typeClass
>         (Just m,dcId) = splitQualIdent dcQId
>         vi = DataConstructor dcQId ets
>         ets = let univVars = length $ nub $ typeVars ty
>                   existsVars = 0
>               in  ForAllExist univVars existsVars ty
>         ty = normalize $ toType [] tyexpr
>         tyexpr = foldr typeExprApplyArrowConstructor baseTyexpr sigs
>         (tyexprWC,tv') = dictTypeClassDataRhs typeClassEnv typeClass
>         sigs = typeExprArguments (removeTypeExprContext tyexprWC)
>         baseTyexpr = removeTypeExprContext
>                    $ dictTypeClassDataLhs typeClassEnv typeClass

\end{lstlisting}
Binding selector functions.
\begin{lstlisting}

> bindSelectorFunctions :: ModuleIdent -> TypeClassEnv -> QualIdent ->
>                          [(Ident,TypeExprWithContext)] ->
>                          ValueEnv -> ValueEnv
> bindSelectorFunctions m typeClassEnv typeClass methods tyEnv =
>   foldr (uncurry (bindSelectorFunction m typeClassEnv typeClass))
>         tyEnv methods

> bindSelectorFunction :: ModuleIdent -> TypeClassEnv -> QualIdent -> Ident ->
>                         TypeExprWithContext ->
>                         ValueEnv -> ValueEnv
> bindSelectorFunction m typeClassEnv typeClass method methodTypeExprWC =
>   qualBindImportTopEnv m selectorId vi
>   where selectorId  = dictSelectorIdent method
>         selectorQId = qualifyWith m $ selectorId
>         vi = Value selectorQId ts
>         ts = polyTypeWithContext
>               (TypeWithContext emptyTypeContext
>                 (toType []
>                   (selectorFunctionTypeExpr typeClassEnv typeClass
>                                             method methodTypeExprWC)))

\end{lstlisting}
Binding traverser functions.
\begin{lstlisting}

> bindTraverserFunctions :: ModuleIdent -> TypeClassEnv ->
>                           QualIdent -> [QualIdent] ->
>                           ValueEnv -> ValueEnv
> bindTraverserFunctions m typeClassEnv typeClass superClasses tyEnv =
>   foldr (bindTraverserFunction m typeClassEnv typeClass) tyEnv superClasses

> bindTraverserFunction :: ModuleIdent -> TypeClassEnv ->
>                          QualIdent -> QualIdent ->
>                          ValueEnv -> ValueEnv
> bindTraverserFunction m typeClassEnv typeClass superTypeClass =
>   qualBindImportTopEnv m traverserId vi
>   where traverserId = dictTraverserIdent typeClass superTypeClass
>         traverserQId = qualifyWith m traverserId
>         vi = Value traverserQId ts
>         ts = polyTypeWithContext
>                (TypeWithContext emptyTypeContext
>                  (toType []
>                    (traverserFunctionTypeExpr typeClassEnv typeClass
>                                               superTypeClass)))

\end{lstlisting}
\codesubsection{Binding instances}
\begin{lstlisting}

> bindDictInstance :: TypeClassEnv -> InstanceInfo -> ValueEnv -> ValueEnv
> bindDictInstance typeClassEnv (InstanceInfo typeClass typeConstr m ctx _ _) =
>   bindInstanceValue typeClassEnv typeClass typeConstr m ctx

> bindInstanceValue :: TypeClassEnv -> QualIdent -> QualIdent ->
>                      ModuleIdent -> [[QualIdent]] -> ValueEnv -> ValueEnv
> bindInstanceValue typeClassEnv typeClass typeConstructor m instCtx =
>   qualBindImportTopEnv m instValueId vi
>   where instValueId = dictInstanceIdent typeClass typeConstructor
>         instValueQId = qualifyWith m instValueId
>         tyexprWC = instanceValueTypeExpr typeClassEnv typeClass
>                                          typeConstructor instCtx
>         ts  = gen zeroSet $ toTypeWithContext [] tyexprWC
>         vi = Value instValueQId ts

\end{lstlisting}
