JAVA_PACKAGES=\
  libzeroc-ice$(RV)-java \
  icegrid-gui

export CLASSPATH=/usr/share/java/db.jar
JAVA_PREFIX=$(CURDIR)/$(DEB_DH_INSTALL_SOURCEDIR)/usr

debian/stamp-build-java:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	prefix=/usr -j $(PROCESSORS)
debian/stamp-build-java:: debian/stamp-build-cpp
	@if test ! -f $@ ; then \
		LD_LIBRARY_PATH="$(CURDIR)/cpp/lib:$$LD_LIBRARY_PATH" ; \
		export LD_LIBRARY_PATH; $(DEB_MAKE_INVOKE) -C java all ; \
	fi
	:> $@

debian/stamp-install-java:: DEB_MAKE_INVOKE := $(DEB_MAKE_ENVVARS) make \
	prefix=$(JAVA_PREFIX) \
	install_slicedir=$(JAVA_PREFIX)/share/Ice-$(V)/slice -j $(PROCESSORS)
debian/stamp-install-java::
	-mkdir -p $(JAVA_PREFIX)
	@if test ! -f $@ ; then \
	  $(DEB_MAKE_INVOKE) -C java install ; \
	  mv $(JAVA_PREFIX)/share/java/Ice.jar \
	    $(JAVA_PREFIX)/share/java/zeroc-ice-$(RV).jar ; \
	  ln -s zeroc-ice-$(RV).jar \
	    $(JAVA_PREFIX)/share/java/Ice.jar ; \
	  mv $(JAVA_PREFIX)/share/java/Freeze.jar \
	    $(JAVA_PREFIX)/share/java/freeze-$(RV).jar ; \
	  ln -s freeze-$(RV).jar \
	    $(JAVA_PREFIX)/share/java/Freeze.jar ; \
	  mv $(JAVA_PREFIX)/share/java/IceGridGUI.jar \
	    $(JAVA_PREFIX)/share/java/IceGridGUI-$(RV).jar ; \
	  cp debian/icegrid-gui.wrapper $(JAVA_PREFIX)/bin/icegrid-gui ; \
	  chmod 755 $(JAVA_PREFIX)/bin/icegrid-gui ; \
	  find $(JAVA_PREFIX)/share/help -type f | xargs chmod 644 ; \
	fi
	:> $@

.PHONY: build/java install/java

build/java:: debian/stamp-build-cpp debian/stamp-build-java
install/java:: debian/stamp-install-java

$(patsubst %,build/%,$(JAVA_PACKAGES)) :: build/% : build/java
$(patsubst %,install/%,$(JAVA_PACKAGES)) :: install/% : install/java

# make -C java clean may fail for binary-arch due to lack of ant
clean::
	-$(MAKE) -C java clean
	$(RM) debian/stamp-build-java debian/stamp-install-java
