/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI;

import Ice.Current;
import IceGrid.RegistryInfo;
import IceGrid._RegistryObserverDisp;
import IceGridGUI.Coordinator;
import javax.swing.SwingUtilities;

class RegistryObserverI
extends _RegistryObserverDisp {
    private final Coordinator _coordinator;
    private final boolean _trace;

    RegistryObserverI(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._trace = this._coordinator.traceObservers();
    }

    public void registryInit(final RegistryInfo[] registryInfos, Current current) {
        if (this._trace) {
            if (registryInfos.length == 0) {
                this._coordinator.traceObserver("registryInit (no registry)");
            } else {
                String names = "";
                for (int i = 0; i < registryInfos.length; ++i) {
                    names = names + " " + registryInfos[i].name;
                }
                this._coordinator.traceObserver("registryInit for registr" + (registryInfos.length == 1 ? "y" : "ies") + names);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < registryInfos.length; ++i) {
                    RegistryObserverI.this._coordinator.registryUp(registryInfos[i]);
                }
            }
        });
    }

    public void registryUp(final RegistryInfo registryInfo, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("registryUp for registry " + registryInfo.name);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.registryUp(registryInfo);
            }
        });
    }

    public void registryDown(final String registryName, Current current) {
        if (this._trace) {
            this._coordinator.traceObserver("registryDown for registry " + registryName);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RegistryObserverI.this._coordinator.registryDown(registryName);
            }
        });
    }
}

