/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import Ice.Util;
import IceGrid.AdapterDescriptor;
import IceGrid.DistributionDescriptor;
import IceGrid.ObjectDescriptor;
import IceGrid.PropertyDescriptor;
import IceGrid.PropertySetDescriptor;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.Root;
import IceGridGUI.TreeNodeBase;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class TreeNode
extends TreeNodeBase {
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract Editor getEditor();

    protected abstract Editor createEditor();

    abstract Object getDescriptor();

    abstract void write(XMLWriter var1) throws IOException;

    public boolean isEphemeral() {
        return false;
    }

    public void destroy() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    TreeNode(TreeNode parent, String id) {
        super(parent, id);
    }

    public Root getRoot() {
        if (!$assertionsDisabled && this._parent == null) {
            throw new AssertionError();
        }
        return ((TreeNode)this._parent).getRoot();
    }

    TreeNode findChildLike(TreeNode other) {
        return (TreeNode)this.findChild(other.getId());
    }

    Utils.Resolver getResolver() {
        if (this.isEphemeral()) {
            return null;
        }
        return ((TreeNode)this._parent).getResolver();
    }

    TreeNode findChildWithDescriptor(Object descriptor) {
        Enumeration p = this.children();
        while (p.hasMoreElements()) {
            TreeNode node = (TreeNode)p.nextElement();
            if (node.getDescriptor() != descriptor) continue;
            return node;
        }
        return null;
    }

    static String[] createAttribute(String name, String value) {
        return new String[]{name, value};
    }

    static void writeVariables(XMLWriter writer, Map variables) throws IOException {
        Iterator p = variables.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(TreeNode.createAttribute("name", entry.getKey().toString()));
            attributes.add(TreeNode.createAttribute("value", entry.getValue().toString()));
            writer.writeElement("variable", attributes);
        }
    }

    static void writePropertySet(XMLWriter writer, PropertySetDescriptor psd, List adapters, String[] logs) throws IOException {
        TreeNode.writePropertySet(writer, "", "", psd, adapters, logs);
    }

    static void writePropertySet(XMLWriter writer, String id, String idAttrName, PropertySetDescriptor psd, List adapters, String[] logs) throws IOException {
        if (id.length() == 0 && psd.references.length == 0 && psd.properties.size() == 0) {
            return;
        }
        HashSet<String> hiddenPropertyNames = new HashSet<String>();
        HashSet<String> hiddenPropertyValues = new HashSet<String>();
        if (adapters != null) {
            Iterator p = adapters.iterator();
            while (p.hasNext()) {
                ObjectDescriptor od;
                AdapterDescriptor ad = (AdapterDescriptor)p.next();
                hiddenPropertyNames.add(ad.name + ".Endpoints");
                Iterator q = ad.objects.iterator();
                while (q.hasNext()) {
                    od = (ObjectDescriptor)q.next();
                    hiddenPropertyValues.add(Util.identityToString(od.id));
                }
                q = ad.allocatables.iterator();
                while (q.hasNext()) {
                    od = (ObjectDescriptor)q.next();
                    hiddenPropertyValues.add(Util.identityToString(od.id));
                }
            }
        }
        if (logs != null) {
            for (int i = 0; i < logs.length; ++i) {
                hiddenPropertyValues.add(logs[i]);
            }
        }
        LinkedList<String[]> attributes = new LinkedList<String[]>();
        if (id.length() > 0) {
            attributes.add(TreeNode.createAttribute(idAttrName, id));
        }
        if (psd.references.length == 0 && psd.properties.size() == 0) {
            writer.writeElement("properties", attributes);
        } else {
            writer.writeStartTag("properties", attributes);
            for (int i = 0; i < psd.references.length; ++i) {
                attributes.clear();
                attributes.add(TreeNode.createAttribute("refid", psd.references[i]));
                writer.writeElement("properties", attributes);
            }
            Iterator p = psd.properties.iterator();
            while (p.hasNext()) {
                PropertyDescriptor pd = (PropertyDescriptor)p.next();
                if (hiddenPropertyNames.contains(pd.name)) {
                    hiddenPropertyNames.remove(pd.name);
                    continue;
                }
                if (hiddenPropertyValues.contains(pd.value)) {
                    hiddenPropertyValues.remove(pd.value);
                    continue;
                }
                attributes.clear();
                attributes.add(TreeNode.createAttribute("name", pd.name));
                attributes.add(TreeNode.createAttribute("value", pd.value));
                writer.writeElement("property", attributes);
            }
            writer.writeEndTag("properties");
        }
    }

    static void writeLogs(XMLWriter writer, String[] logs, List properties) throws IOException {
        for (int i = 0; i < logs.length; ++i) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(TreeNode.createAttribute("path", logs[i]));
            String prop = TreeNode.lookupName(logs[i], properties);
            if (prop != null) {
                attributes.add(TreeNode.createAttribute("property", prop));
            }
            writer.writeElement("log", attributes);
        }
    }

    static String lookupName(String val, List properties) {
        Iterator p = properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            if (!pd.value.equals(val)) continue;
            return pd.name;
        }
        return null;
    }

    static void writeDistribution(XMLWriter writer, DistributionDescriptor descriptor) throws IOException {
        if (descriptor.icepatch.length() > 0) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(TreeNode.createAttribute("icepatch", descriptor.icepatch));
            if (descriptor.directories.isEmpty()) {
                writer.writeElement("distrib", attributes);
            } else {
                writer.writeStartTag("distrib", attributes);
                Iterator p = descriptor.directories.iterator();
                while (p.hasNext()) {
                    writer.writeElement("directory", p.next().toString());
                }
                writer.writeEndTag("distrib");
            }
        }
    }

    static void writeObjects(String elt, XMLWriter writer, List objects, List properties) throws IOException {
        Iterator p = objects.iterator();
        while (p.hasNext()) {
            String prop;
            ObjectDescriptor od = (ObjectDescriptor)p.next();
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            String strId = Util.identityToString(od.id);
            attributes.add(TreeNode.createAttribute("identity", strId));
            if (od.type.length() > 0) {
                attributes.add(TreeNode.createAttribute("type", od.type));
            }
            if (properties != null && (prop = TreeNode.lookupName(strId, properties)) != null) {
                attributes.add(TreeNode.createAttribute("property", prop));
            }
            writer.writeElement(elt, attributes);
        }
    }

    static void writeParameters(XMLWriter writer, List parameters, Map defaultValues) throws IOException {
        Iterator p = new LinkedHashSet(parameters).iterator();
        while (p.hasNext()) {
            String parameter = (String)p.next();
            String val = (String)defaultValues.get(parameter);
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(TreeNode.createAttribute("name", parameter));
            if (val != null) {
                attributes.add(TreeNode.createAttribute("default", val));
            }
            writer.writeElement("parameter", attributes);
        }
    }

    static LinkedList parameterValuesToAttributes(Map parameterValues, List parameters) {
        LinkedList<String[]> result = new LinkedList<String[]>();
        Iterator p = new LinkedHashSet(parameters).iterator();
        while (p.hasNext()) {
            String param = (String)p.next();
            String val = (String)parameterValues.get(param);
            if (val == null) continue;
            result.add(TreeNode.createAttribute(param, val));
        }
        return result;
    }

    public boolean[] getAvailableActions() {
        return new boolean[20];
    }

    public void newAdapter() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newDbEnv() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newNode() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newPropertySet() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newReplicaGroup() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newServer() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newServerIceBox() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newServerFromTemplate() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newService() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newServiceFromTemplate() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newTemplateServer() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newTemplateServerIceBox() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void newTemplateService() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void copy() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void paste() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void delete() {
        boolean enabled = this.getRoot().isSelectionListenerEnabled();
        if (enabled) {
            this.getRoot().disableSelectionListener();
        }
        this.destroy();
        this.getCoordinator().getCurrentTab().showNode(null);
        if (enabled) {
            this.getRoot().enableSelectionListener();
        }
        if (this._parent != null) {
            this.getRoot().setSelectedNode((TreeNode)this._parent);
        }
    }

    public void moveUp() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void moveDown() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !TreeNode.class.desiredAssertionStatus();
    }
}

