/* logging.c generated by valac 0.14.2, the Vala compiler
 * generated from logging.vala, do not modify */

/* logging.vala
 *
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))


extern FILE* zeitgeist_logging_log_file;
FILE* zeitgeist_logging_log_file = NULL;

#define ZEITGEIST_LOGGING_BLUE "\x1b[34m"
#define ZEITGEIST_LOGGING_GREEN "\x1b[32m"
#define ZEITGEIST_LOGGING_RED "\x1b[31m"
#define ZEITGEIST_LOGGING_YELLOW "\x1b[33m"
#define ZEITGEIST_LOGGING_RESET "\x1b[0m"
gchar* zeitgeist_logging_get_log_level_string (GLogLevelFlags log_levels, gchar** color);
void zeitgeist_logging_log_handler (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message);
void zeitgeist_logging_setup_logging (const gchar* log_level, const gchar* log_file);
static void ___lambda11_ (void);
static void ____lambda11__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void _zeitgeist_logging_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);


gchar* zeitgeist_logging_get_log_level_string (GLogLevelFlags log_levels, gchar** color) {
	gchar* _vala_color = NULL;
	gchar* result = NULL;
	gchar* log_level = NULL;
	GLogLevelFlags _tmp0_;
	_tmp0_ = log_levels;
	if ((_tmp0_ & G_LOG_LEVEL_ERROR) != 0) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_strdup ("ERROR");
		_g_free0 (log_level);
		log_level = _tmp1_;
		_tmp2_ = g_strdup (ZEITGEIST_LOGGING_RED);
		_g_free0 (_vala_color);
		_vala_color = _tmp2_;
	} else {
		GLogLevelFlags _tmp3_;
		_tmp3_ = log_levels;
		if ((_tmp3_ & G_LOG_LEVEL_CRITICAL) != 0) {
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = g_strdup ("CRITICAL");
			_g_free0 (log_level);
			log_level = _tmp4_;
			_tmp5_ = g_strdup (ZEITGEIST_LOGGING_RED);
			_g_free0 (_vala_color);
			_vala_color = _tmp5_;
		} else {
			GLogLevelFlags _tmp6_;
			_tmp6_ = log_levels;
			if ((_tmp6_ & G_LOG_LEVEL_WARNING) != 0) {
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup ("WARNING");
				_g_free0 (log_level);
				log_level = _tmp7_;
				_tmp8_ = g_strdup (ZEITGEIST_LOGGING_RED);
				_g_free0 (_vala_color);
				_vala_color = _tmp8_;
			} else {
				GLogLevelFlags _tmp9_;
				_tmp9_ = log_levels;
				if ((_tmp9_ & G_LOG_LEVEL_MESSAGE) != 0) {
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = g_strdup ("MESSAGE");
					_g_free0 (log_level);
					log_level = _tmp10_;
					_tmp11_ = g_strdup (ZEITGEIST_LOGGING_BLUE);
					_g_free0 (_vala_color);
					_vala_color = _tmp11_;
				} else {
					GLogLevelFlags _tmp12_;
					_tmp12_ = log_levels;
					if ((_tmp12_ & G_LOG_LEVEL_INFO) != 0) {
						gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp13_ = g_strdup ("INFO");
						_g_free0 (log_level);
						log_level = _tmp13_;
						_tmp14_ = g_strdup (ZEITGEIST_LOGGING_BLUE);
						_g_free0 (_vala_color);
						_vala_color = _tmp14_;
					} else {
						GLogLevelFlags _tmp15_;
						_tmp15_ = log_levels;
						if ((_tmp15_ & G_LOG_LEVEL_DEBUG) != 0) {
							gchar* _tmp16_;
							gchar* _tmp17_;
							_tmp16_ = g_strdup ("DEBUG");
							_g_free0 (log_level);
							log_level = _tmp16_;
							_tmp17_ = g_strdup (ZEITGEIST_LOGGING_GREEN);
							_g_free0 (_vala_color);
							_vala_color = _tmp17_;
						} else {
							gchar* _tmp18_;
							gchar* _tmp19_;
							_tmp18_ = g_strdup ("UNKNOWN");
							_g_free0 (log_level);
							log_level = _tmp18_;
							_tmp19_ = g_strdup (ZEITGEIST_LOGGING_BLUE);
							_g_free0 (_vala_color);
							_vala_color = _tmp19_;
						}
					}
				}
			}
		}
	}
	result = log_level;
	if (color) {
		*color = _vala_color;
	} else {
		_g_free0 (_vala_color);
	}
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


void zeitgeist_logging_log_handler (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message) {
	gchar* color = NULL;
	GLogLevelFlags _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* log_level;
	GTimeVal _tmp3_ = {0};
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* timestamp;
	FILE* output = NULL;
	GLogLevelFlags _tmp8_;
	FILE* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	FILE* _tmp16_;
	g_return_if_fail (message != NULL);
	_tmp0_ = log_levels;
	_tmp2_ = zeitgeist_logging_get_log_level_string (_tmp0_, &_tmp1_);
	_g_free0 (color);
	color = _tmp1_;
	log_level = _tmp2_;
	g_get_current_time (&_tmp3_);
	_tmp4_ = g_time_val_to_iso8601 (&_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_substring (_tmp5_, (glong) 11, (glong) 15);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	timestamp = _tmp7_;
	_tmp8_ = log_levels;
	if (_tmp8_ >= G_LOG_LEVEL_MESSAGE) {
		FILE* _tmp9_;
		_tmp9_ = stdout;
		output = _tmp9_;
	} else {
		FILE* _tmp10_;
		_tmp10_ = stderr;
		output = _tmp10_;
	}
	_tmp11_ = output;
	_tmp12_ = color;
	_tmp13_ = timestamp;
	_tmp14_ = log_level;
	_tmp15_ = message;
	fprintf (_tmp11_, "%s[%s %s]%s %s\n", _tmp12_, _tmp13_, _tmp14_, ZEITGEIST_LOGGING_RESET, _tmp15_);
	_tmp16_ = zeitgeist_logging_log_file;
	if (_tmp16_ != NULL) {
		GDateTime* _tmp17_;
		GDateTime* datetime;
		GDateTime* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		GDateTime* _tmp21_;
		gint _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* date_string;
		pid_t _tmp25_ = 0;
		gint pid;
		FILE* _tmp26_;
		gint _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp17_ = g_date_time_new_now_local ();
		datetime = _tmp17_;
		_tmp18_ = datetime;
		_tmp19_ = g_date_time_format (_tmp18_, "%Y-%m-%d %H:%M:%S");
		_tmp20_ = _tmp19_;
		_tmp21_ = datetime;
		_tmp22_ = g_date_time_get_microsecond (_tmp21_);
		_tmp23_ = g_strdup_printf ("%s,%.3d", _tmp20_, (gint) (_tmp22_ / 1000.0));
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp20_);
		date_string = _tmp24_;
		_tmp25_ = getpid ();
		pid = (gint) _tmp25_;
		_tmp26_ = zeitgeist_logging_log_file;
		_tmp27_ = pid;
		_tmp28_ = date_string;
		_tmp29_ = log_level;
		_tmp30_ = message;
		fprintf (_tmp26_, "%d [%s] - %s - %s\n", _tmp27_, _tmp28_, _tmp29_, _tmp30_);
		_g_free0 (date_string);
		_g_date_time_unref0 (datetime);
	}
	_g_free0 (timestamp);
	_g_free0 (log_level);
	_g_free0 (color);
}


static void ___lambda11_ (void) {
}


static void ____lambda11__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	___lambda11_ ();
}


static void _zeitgeist_logging_log_handler_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	zeitgeist_logging_log_handler (log_domain, log_levels, message);
}


void zeitgeist_logging_setup_logging (const gchar* log_level, const gchar* log_file) {
	GLogLevelFlags discarded;
	const gchar* _tmp0_;
	GLogLevelFlags _tmp19_;
	const gchar* _tmp21_;
	GLogLevelFlags _tmp24_;
	GLogLevelFlags logged;
	discarded = G_LOG_LEVEL_DEBUG;
	_tmp0_ = log_level;
	if (_tmp0_ != NULL) {
		GLogLevelFlags ld;
		GLogLevelFlags li;
		GLogLevelFlags lm;
		GLogLevelFlags lw;
		GLogLevelFlags lc;
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GQuark _tmp5_ = 0U;
		static GQuark _tmp4_label0 = 0;
		static GQuark _tmp4_label1 = 0;
		static GQuark _tmp4_label2 = 0;
		static GQuark _tmp4_label3 = 0;
		static GQuark _tmp4_label4 = 0;
		ld = G_LOG_LEVEL_DEBUG;
		li = G_LOG_LEVEL_INFO;
		lm = G_LOG_LEVEL_MESSAGE;
		lw = G_LOG_LEVEL_WARNING;
		lc = G_LOG_LEVEL_CRITICAL;
		_tmp1_ = log_level;
		_tmp2_ = g_utf8_strup (_tmp1_, (gssize) (-1));
		_tmp3_ = _tmp2_;
		_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
		g_free (_tmp3_);
		if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("DEBUG")))) {
			switch (0) {
				default:
				{
					discarded = 0;
					break;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("INFO")))) {
			switch (0) {
				default:
				{
					GLogLevelFlags _tmp6_;
					_tmp6_ = ld;
					discarded = _tmp6_;
					break;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("WARNING")))) {
			switch (0) {
				default:
				{
					GLogLevelFlags _tmp7_;
					GLogLevelFlags _tmp8_;
					GLogLevelFlags _tmp9_;
					_tmp7_ = ld;
					_tmp8_ = li;
					_tmp9_ = lm;
					discarded = (_tmp7_ | _tmp8_) | _tmp9_;
					break;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("CRITICAL")))) {
			switch (0) {
				default:
				{
					GLogLevelFlags _tmp10_;
					GLogLevelFlags _tmp11_;
					GLogLevelFlags _tmp12_;
					GLogLevelFlags _tmp13_;
					_tmp10_ = ld;
					_tmp11_ = li;
					_tmp12_ = lm;
					_tmp13_ = lw;
					discarded = ((_tmp10_ | _tmp11_) | _tmp12_) | _tmp13_;
					break;
				}
			}
		} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("ERROR")))) {
			switch (0) {
				default:
				{
					GLogLevelFlags _tmp14_;
					GLogLevelFlags _tmp15_;
					GLogLevelFlags _tmp16_;
					GLogLevelFlags _tmp17_;
					GLogLevelFlags _tmp18_;
					_tmp14_ = ld;
					_tmp15_ = li;
					_tmp16_ = lm;
					_tmp17_ = lw;
					_tmp18_ = lc;
					discarded = (((_tmp14_ | _tmp15_) | _tmp16_) | _tmp17_) | _tmp18_;
					break;
				}
			}
		}
	}
	_tmp19_ = discarded;
	if (_tmp19_ != 0) {
		GLogLevelFlags _tmp20_;
		_tmp20_ = discarded;
		g_log_set_handler (NULL, _tmp20_, ____lambda11__glog_func, NULL);
	}
	_tmp21_ = log_file;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		FILE* _tmp23_ = NULL;
		_tmp22_ = log_file;
		_tmp23_ = fopen (_tmp22_, "a");
		_fclose0 (zeitgeist_logging_log_file);
		zeitgeist_logging_log_file = _tmp23_;
	}
	_tmp24_ = discarded;
	logged = (~_tmp24_) & (~G_LOG_FLAG_RECURSION);
	g_log_set_handler (NULL, logged, _zeitgeist_logging_log_handler_glog_func, NULL);
}



