/*
 * Zaz
 * Copyright (C) Remigiusz Dybka 2009 <remigiusz.dybka@gmail.com>
 *
 Zaz is free software: you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Zaz is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __MAINMENU_H__
#define __MAINMENU_H__

#include <vector>

#include "common.h"
#include "menu.h"
#include "scene.h"
#include "level.h"
#include "ballpath.h"
#include "game.h"

struct LevelDesc
{
    Level lev;
    GLuint tex;
    bool locked;

    LevelDesc(const char *philename)
            : lev(philename, true), tex(0), locked(true) {};
};

class MainMenu : public Scenes::Scene
{
        friend void optionsMenuBackHandler(void *ptr);
        friend void startMenuOptionsHandler(void *ptr);
        friend void startMenuExitHandler(void *ptr);
        friend void startMenuStartHandler(void *ptr);
        friend void startMenuCreditsHandler(void *ptr);
        friend void browserMenuLeftHandler(void *ptr);
        friend void browserMenuRightHandler(void *ptr);
        const static uint browserNLevelsPerPage = 3;
        const static uint browserThumbSpacing = 5;

        double vwidth;
        double vleft;
        double vheight;
        double mx;
        double my;

        Menu startMenu;
        Menu optionsMenu;
        Menu creditsMenu;
        Menu browserMenu;

        Menu *currentMenu;

        GLuint logoTex;

        Level menuLev;

        GLuint ballText[NBALLCOLORS + BONUS_BOMB + 2];
        std::vector<BallPath> bp;

        int nBallPaths;

        Scenes::Sample *music;
        bool renderHiscores;
        bool showCredits;
        bool showBrowser;

        void StartMusic();
        void StopMusic();

        bool oldFullscreen;
        string oldRes;
        void CenterMsg(string msg, double y, FTFont *font, double size = 0.2);
        void LoadTextures();

        GLuint logoGpl;
        vector<LevelDesc>levels;

        bool startup;
        float startupProgress;
        float startupProgressSteps;
        void RenderStartupProgress();

        double browserScrollOffset;
        int browserScrollOffsetDest;
        int browserSelectedLevel;

    public:
        MainMenu(Scenes::Settings *settings, SDL_Surface *surf, uint fps = Scenes::DEFAULT_FPS);
        ~MainMenu();
        void GLSetup();
        void Render(ulong frame);


        void Logic(ulong frame);
};

void optionsMenuBackHandler(void *ptr);
void startMenuOptionsHandler(void *ptr);
void startMenuExitHandler(void *ptr);
void startMenuStartHandler(void *ptr);
void startMenuCreditsHandler(void *ptr);
void browserMenuLeftHandler(void *ptr);
void browserMenuRightHandler(void *ptr);

#endif //__MAINMENU_H__
