/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

double scl=0.08;
int maxx=10;
int maxy=10;
 
#include <stdlib.h>
#include <stdio.h>
#include "swindow/SAwt.h"
#include "stoolkit/SEvent.h"
#ifndef USE_WINAPI
#include <sys/time.h>
#else
#include <winsock.h>
#include <time.h>
#endif


#define DEFAULT_CONFIG "/usr/share/yudit/config/yuditrc"

void timerStart();
void timerStop();

class Listener : public SWindowListener
{
public:
  Listener() : SWindowListener() {}
  ~Listener() {}
  virtual void redraw(SWindow* w, int x, int y, 
    unsigned int width ,unsigned int height);
  virtual bool windowClose (SWindow* w)
  {
    fprintf (stderr, "Window closing..\n");
    return true;
  }
};
void drawIt (SWindow * w);
void
Listener::redraw (SWindow* w, int x, int y, unsigned int width ,
  unsigned int height)
{
  timerStart();
  drawIt(w);
  timerStop();
}

SPen pen (SColor(0.0,0.0,0.0, 1.0), SColor(1.0, 1.0, 1.0, 1.0), 1.0);

void drawIt (SWindow * w)
{
  //w->setBackground (SColor(0.5, 0.6, 0.7, 1.0));
  w->setBackground (SColor(1.0,1.0,1.0, 1.0));
  w->pushmatrix();
  w->scale(scl, scl);
  //w->scale(0.08, 0.08);
  //w->scale(0.07, 0.07);
  //w->scale(0.05, 0.05);
for (int y=0; y<maxy; y++)
{
for (int x=0; x<maxx; x++)
{
  // fprintf (stderr, "redraw\n");
  //SPen pen (SColor(0.0,0.0,0.0, 1.0), SColor(0.5, 0.6, 0.7, 1.0), 0.124);
  //SPen pen (SColor(0.0,0.0,0.0, 1.0), SColor(0.9, 0.6, 0.7, 1.0), 1.0);

  /** 
   * The glyph INUI
   */
  if (w->newpath (scl * 60.0/0.08 * double (x),
       scl* 25.0 / 0.08 * (double) y, "Yuko"))
  {
    w->fill (pen);
    continue;
  }
  fprintf (stderr, "DRawing\n");
  w->pushmatrix();
  w->translate(scl * 60.0/0.08 * double (x), scl* 25.0 / 0.08 * (double) y);
  w->moveto (118.5, 69.25);
  w->lineto (106.75, 81.75);
  w->lineto (87.25, 81.75);
  w->lineto (87.25, 63.25);
  w->curveto (87.5, 60.25, 88.25, 58.25, 89.25, 57);
  w->curveto (91, 56, 92, 54.25, 92, 51.5);
  w->curveto (92, 50.875, 90.625, 50.25, 88, 49.75);
  w->curveto (83.5, 49.125, 78.625, 47.75, 73.5, 45.75);
  w->curveto (74.75, 49.625, 75.5, 54.75, 75.5, 61.25);
  w->lineto (75.5, 81.75);
  w->lineto (25.75, 81.75);
  w->lineto (29.5, 88.75);
  w->lineto (75.5, 88.75);
  w->lineto (75.5, 114);
  w->lineto (52, 114);
  w->lineto (38.25, 107.25);
  w->curveto (40.25, 113, 41.25, 119.125, 41.25, 125.75);
  w->lineto (41.25, 193.25);
  w->curveto (41.25, 194.5, 41.875, 195, 43.25, 195);
  w->lineto (50.75, 192.25);
  w->curveto (52.25, 191.75, 53, 191.125, 53, 190.25);
  w->lineto (53, 182.5);
  w->lineto (76.5, 182.5);
  w->lineto (76.5, 209.75);
  w->lineto (21.75, 209.75);
  w->lineto (25.75, 216.5);
  w->lineto (76.5, 216.5);
  w->lineto (76.5, 267.5);
  w->curveto (76.5, 268.625, 77, 269.25, 78.25, 269.25);
  w->lineto (86, 266.25);
  w->curveto (87.5, 265.5, 88.25, 264.625, 88.25, 263.5);
  w->lineto (88.25, 216.5);
  w->lineto (135, 216.5);
  w->curveto (138.75, 216.5, 140.75, 215.25, 140.75, 212.75);
  w->curveto (140.75, 211.125, 139.375, 209.75, 136.75, 208.75);
  w->curveto (130.5, 205, 125.75, 200.75, 122.25, 196);
  w->lineto (110.5, 209.75);
  w->lineto (88.25, 209.75);
  w->lineto (88.25, 182.5);
  w->lineto (110.5, 182.5);
  w->lineto (110.5, 186.25);
  w->curveto (110.5, 187.625, 111.125, 188.25, 112.5, 188.25);
  w->lineto (120, 185.75);
  w->curveto (121.5, 185.125, 122.25, 184.375, 122.25, 183.5);
  w->lineto (122.25, 130.75);
  w->curveto (122.25, 128.75, 123.25, 126.75, 125.25, 124.75);
  w->curveto (127.875, 123.625, 129.25, 122.375, 129.25, 121);
  w->curveto (129.25, 119, 127.75, 117.375, 125, 116);
  w->curveto (121.625, 114.25, 118.125, 111.25, 114.5, 107.25);
  w->lineto (106.75, 114);
  w->lineto (87.25, 114);
  w->lineto (87.25, 88.75);
  w->lineto (131, 88.75);
  w->curveto (134.25, 88.75, 136, 87.5, 136, 84.75);
  w->curveto (136, 83.25, 134.75, 82, 132.25, 81);
  w->curveto (126.25, 77.375, 121.625, 73.5, 118.5, 69.25);
  w->closepath ();
  w->moveto (53, 175.5);
  w->lineto (53, 151.25);
  w->lineto (110.5, 151.25);
  w->lineto (110.5, 175.5);
  w->closepath ();
  w->moveto (53, 144.25);
  w->lineto (53, 121);
  w->lineto (110.5, 121);
  w->lineto (110.5, 144.25);
  w->closepath ();
  w->moveto (166.25, 44.75);
  w->curveto (161.25, 66.25, 156.375, 82.25, 151.75, 92.75);
  w->curveto (146.375, 105.75, 138.875, 118.5, 129.25, 130.75);
  w->lineto (130, 133.5);
  w->curveto (139.125, 127, 147.375, 117.75, 154.75, 105.5);
  w->curveto (155.5, 104.25, 156.25, 102.75, 157, 101.25);
  w->lineto (242.5, 101.25);
  w->curveto (245, 101.25, 246.25, 100, 246.25, 97.5);
  w->curveto (246.25, 96.375, 245.25, 95, 243.5, 93.5);
  w->curveto (237.125, 90.875, 231.875, 86.625, 227.75, 80.75);
  w->lineto (215, 94.5);
  w->lineto (160.75, 94.5);
  w->curveto (165.5, 84.875, 170, 74.125, 174, 62.25);
  w->curveto (175.625, 60.25, 177.875, 59, 180.75, 58.5);
  w->curveto (182.75, 57.875, 183.75, 56.875, 183.75, 55.5);
  w->curveto (183.75, 54.5, 182.25, 53.5, 179.5, 52.25);
  w->curveto (175.625, 50.75, 171.25, 48.25, 166.25, 44.75);
  w->closepath ();
  w->moveto (219, 130.75);
  w->lineto (209.25, 138.5);
  w->lineto (141.75, 138.5);
  w->lineto (145.75, 145.25);
  w->lineto (210.25, 145.25);
  w->curveto (184, 175, 165, 198.25, 153, 215.25);
  w->curveto (144.75, 226.125, 140.75, 234.25, 140.75, 240);
  w->curveto (140.75, 244.625, 142.875, 248.375, 147.25, 251.25);
  w->curveto (152, 256, 166.25, 258.5, 190, 258.5);
  w->curveto (211.125, 258.5, 226.75, 256.75, 237, 253.25);
  w->curveto (242.75, 251.25, 246.25, 248.5, 247.25, 245);
  w->curveto (247.25, 244.625, 246, 242.75, 243.5, 239.5);
  w->curveto (242.125, 238.25, 241.5, 236.5, 241.5, 234.25);
  w->lineto (237.5, 211.75);
  w->lineto (234.5, 211.75);
  w->curveto (233.25, 227.25, 231.75, 236.875, 230, 240.75);
  w->curveto (229.125, 243.25, 227.75, 244.75, 226, 245.25);
  w->curveto (220.25, 246.875, 208.25, 247.75, 190, 247.75);
  w->curveto (172.125, 247.75, 161.375, 246.625, 157.75, 244.5);
  w->curveto (154.25, 243.25, 152.5, 241.75, 152.5, 240);
  w->curveto (152.5, 235.25, 155.875, 228.625, 162.75, 219.75);
  w->curveto (174.875, 204.125, 193, 182.5, 217, 155);
  w->curveto (218.5, 153.5, 221.75, 152.625, 226.75, 152.25);
  w->curveto (230.75, 152.25, 232.75, 151, 232.75, 148.25);
  w->curveto (232.75, 146.625, 231.75, 145.25, 229.75, 144.25);
  w->curveto (226, 141.125, 222.5, 136.625, 219, 130.75);
  w->closepath ();

  /**
   * The glyph yuu
   */
  w->moveto (299.5, 43.75);
  w->curveto (295, 71.5, 288.25, 95.375, 279.5, 115.5);
  w->curveto (272.625, 132.875, 263.75, 148.75, 252.75, 163);
  w->lineto (254.75, 164.75);
  w->curveto (267.75, 150.5, 278.5, 134.875, 287.25, 118);
  w->curveto (287.375, 117.75, 287.5, 117.375, 287.75, 117);
  w->lineto (287.75, 265.5);
  w->curveto (287.75, 267.25, 288.375, 268.25, 289.75, 268.25);
  w->lineto (297.5, 265.25);
  w->curveto (298.75, 264.5, 299.5, 263.625, 299.5, 262.5);
  w->lineto (299.5, 110.25);
  w->curveto (299.5, 108.75, 299.875, 107.375, 300.75, 106);
  w->curveto (301.875, 104.875, 302.5, 104, 302.5, 103.25);
  w->curveto (302.5, 102, 301.375, 101, 299.25, 100.5);
  w->lineto (297.25, 99.5);
  w->curveto (302, 88.875, 306.75, 76.125, 311.25, 61.25);
  w->curveto (311.75, 60.125, 313.25, 59.25, 315.75, 58.5);
  w->curveto (317.875, 58.375, 319, 57.375, 319, 55.5);
  w->curveto (319, 54.375, 317.5, 53.25, 314.5, 52);
  w->curveto (310, 50.5, 305, 47.75, 299.5, 43.75);
  w->closepath ();
  w->moveto (458.75, 42.75);
  w->lineto (448, 54.5);
  w->lineto (325, 54.5);
  w->lineto (328.75, 61.25);
  w->lineto (388.5, 61.25);
  w->curveto (387.125, 66.75, 385.25, 72.375, 383, 78);
  w->lineto (364.5, 78);
  w->lineto (349.5, 71);
  w->curveto (350, 75.25, 350.25, 79.75, 350.25, 84.75);
  w->lineto (350.25, 138.5);
  w->lineto (330.75, 138.5);
  w->curveto (330.75, 136.375, 330.75, 134.125, 330.75, 131.75);
  w->lineto (328, 131.75);
  w->curveto (327, 140.25, 325.25, 146.25, 323, 149.5);
  w->curveto (321, 153.5, 317.875, 157.125, 313.75, 160.25);
  w->curveto (310.75, 162.75, 309.25, 164.625, 309.25, 165.75);
  w->curveto (310.25, 169.25, 312.5, 171.25, 316.25, 171.75);
  w->curveto (317.875, 171.75, 319.75, 170.75, 322, 168.75);
  w->curveto (324.625, 166.5, 326.625, 163.125, 328, 158.75);
  w->curveto (329.125, 155.625, 329.875, 151.125, 330.25, 145.25);
  w->lineto (455.75, 145.25);
  w->curveto (452.875, 150.75, 450.25, 155, 448, 158);
  w->lineto (449, 159);
  w->curveto (453.625, 157, 458.5, 154.5, 463.75, 151.25);
  w->curveto (464.875, 150.625, 467.375, 150.125, 471.25, 149.75);
  w->curveto (473.875, 149.25, 475.25, 148.125, 475.25, 146.25);
  w->curveto (475.25, 144.5, 474.25, 143, 472.5, 142);
  w->curveto (468.625, 140, 465, 136.875, 461.75, 132.5);
  w->lineto (454.75, 138.5);
  w->lineto (444, 138.5);
  w->lineto (444, 95.5);
  w->curveto (444, 93.25, 445, 91.375, 447, 90);
  w->curveto (450.25, 88.25, 452, 86.75, 452, 85.75);
  w->curveto (452, 84.25, 450.75, 82.75, 448.25, 81);
  w->curveto (445, 79.25, 442, 76.25, 439.25, 72);
  w->lineto (431.5, 78);
  w->lineto (387, 78);
  w->curveto (392.25, 73.25, 396.875, 67.625, 400.75, 61.25);
  w->lineto (470.5, 61.25);
  w->curveto (473.625, 61.25, 475.25, 60, 475.25, 57.5);
  w->curveto (475.25, 56, 474, 54.75, 471.75, 53.75);
  w->curveto (466.25, 50.5, 461.875, 46.75, 458.75, 42.75);
  w->closepath ();
  w->moveto (362, 138.5);
  w->lineto (362, 126.75);
  w->lineto (432.5, 126.75);
  w->lineto (432.5, 138.5);
  w->closepath ();
  w->moveto (362, 120);
  w->lineto (362, 106.25);
  w->lineto (432.5, 106.25);
  w->lineto (432.5, 120);
  w->closepath ();
  w->moveto (362, 99.5);
  w->lineto (362, 84.75);
  w->lineto (432.5, 84.75);
  w->lineto (432.5, 99.5);
  w->closepath ();
  w->moveto (342.5, 159);
  w->curveto (339.75, 166.25, 335, 172, 328, 176.5);
  w->curveto (324.625, 179.25, 323, 181.875, 323, 184.5);
  w->curveto (323.75, 186.75, 325.75, 188, 328.75, 188.25);
  w->curveto (331.75, 188.25, 334.75, 186, 338, 181.25);
  w->curveto (341.25, 176.25, 343.5, 168.875, 344.5, 159);
  w->closepath ();
  w->moveto (360, 151.25);
  w->curveto (360.625, 156.25, 361, 160.5, 361, 163.75);
  w->lineto (361, 167.75);
  w->curveto (361, 175.25, 362.75, 180.375, 366.5, 183);
  w->curveto (367.5, 184.25, 369.375, 185.125, 372.25, 185.75);
  w->curveto (364.375, 197.125, 357.25, 205.5, 350.75, 211);
  w->curveto (344, 218, 329.875, 228.75, 308.25, 243);
  w->lineto (309.25, 244);
  w->curveto (326.875, 235.75, 341.625, 227.375, 353.5, 218.5);
  w->curveto (356.75, 216.25, 360.125, 213.5, 363.5, 210.5);
  w->curveto (372.25, 224.25, 381, 234.25, 389.5, 241);
  w->curveto (381, 245.625, 372, 249.5, 362.5, 252.75);
  w->curveto (347.25, 257.875, 328.625, 262.5, 306.5, 266.5);
  w->lineto (307.5, 268.25);
  w->curveto (339.125, 266.375, 365.875, 260.75, 387.75, 251.5);
  w->curveto (391, 250.125, 394.5, 248.5, 398, 246.75);
  w->curveto (405.25, 251.25, 413.75, 255.25, 423.5, 258.75);
  w->curveto (434.625, 262.875, 445.375, 265.75, 455.75, 267.5);
  w->curveto (459.75, 261.25, 466.25, 257.375, 475.25, 255.75);
  w->lineto (475.25, 252.75);
  w->curveto (459.375, 252, 446, 250.375, 435.25, 247.75);
  w->curveto (425.25, 245.375, 416.5, 242.75, 409.25, 240);
  w->curveto (419.5, 233.25, 430.25, 225, 441.25, 214.75);
  w->curveto (442, 213.5, 443.875, 212.625, 446.75, 212.25);
  w->curveto (449.5, 212, 451, 210.75, 451, 208.75);
  w->curveto (451, 207.625, 449.75, 206.125, 447.25, 204.25);
  w->curveto (445.25, 202.5, 442.5, 199.125, 439.25, 194.25);
  w->lineto (429.5, 199);
  w->lineto (374.25, 199);
  w->curveto (377.375, 195.375, 380.5, 191.375, 383.75, 187);
  w->curveto (387.25, 187.25, 391.125, 187.25, 395.5, 187.25);
  w->curveto (412.625, 187.25, 423.5, 186.25, 428.25, 184.25);
  w->curveto (430.25, 183.125, 432.25, 180.875, 434.25, 177.5);
  w->curveto (434.25, 177.25, 433.75, 176.75, 432.75, 176);
  w->curveto (431.75, 175.375, 431, 173.25, 430.75, 169.75);
  w->curveto (430.75, 168, 430.625, 165.375, 430.5, 162);
  w->lineto (428.5, 162);
  w->curveto (428, 165.5, 427.25, 168.375, 426.5, 170.5);
  w->curveto (425.75, 174.375, 424, 176.5, 421.25, 176.75);
  w->curveto (418.25, 177.25, 409.625, 177.5, 395.5, 177.5);
  w->curveto (382.75, 177.5, 375.375, 176.625, 373.25, 174.75);
  w->curveto (371.5, 173, 370.75, 170.625, 370.75, 167.75);
  w->lineto (370.75, 163.75);
  w->curveto (370.75, 161.75, 371.25, 160.25, 372.5, 159.25);
  w->curveto (374, 158.625, 374.75, 157.5, 374.75, 156);
  w->curveto (374.75, 155.5, 373.5, 155, 371.25, 154.5);
  w->curveto (367.75, 153.875, 364, 152.75, 360, 151.25);
  w->closepath ();
  w->moveto (365, 209);
  w->curveto (366, 208, 367, 207, 368, 205.75);
  w->lineto (432.5, 205.75);
  w->curveto (421.5, 219.25, 410.25, 229.125, 399, 235.25);
  w->curveto (398.125, 234.875, 397.375, 234.5, 396.75, 234);
  w->curveto (385.25, 228, 374.625, 219.75, 365, 209);
  w->closepath ();
  w->moveto (386.5, 149.25);
  w->lineto (385.5, 151.25);
  w->curveto (392.125, 156.125, 396.5, 160.75, 398.75, 165);
  w->curveto (400.25, 167.5, 401.25, 168.75, 402, 168.75);
  w->curveto (405.125, 168.75, 406.75, 166.25, 407, 161);
  w->curveto (407, 159.375, 406, 157.875, 404.25, 156.5);
  w->curveto (401.375, 154.375, 395.5, 152, 386.5, 149.25);
  w->closepath ();
  w->moveto (431.5, 153.25);
  w->lineto (430.5, 154);
  w->curveto (434.75, 158.25, 437.75, 161.625, 439.5, 164.25);
  w->curveto (441.125, 166.625, 443, 170.375, 445, 175.5);
  w->curveto (446.5, 179.375, 448.75, 181.375, 452, 181.5);
  w->curveto (453.5, 181.5, 455, 180.625, 456.5, 178.75);
  w->curveto (457.25, 177.125, 457.75, 174.5, 457.75, 170.75);
  w->curveto (457.75, 169, 455.875, 166.625, 452.25, 163.75);
  w->curveto (447.875, 160.75, 441, 157.25, 431.5, 153.25);
  w->closepath ();

  /*
   * The glyph ko
   */
  w->moveto (667.25, 54.5);
  w->lineto (657.5, 63.25);
  w->lineto (513, 63.25);
  w->lineto (517, 70);
  w->lineto (659.5, 70);
  w->curveto (638.625, 88, 618, 102.75, 597.75, 114.25);
  w->curveto (594.25, 113.625, 590.375, 112.625, 586.25, 111.25);
  w->curveto (587.5, 115.75, 588.25, 122.625, 588.25, 131.75);
  w->lineto (588.25, 149.25);
  w->lineto (483.75, 149.25);
  w->lineto (487.5, 156);
  w->lineto (588.25, 156);
  w->lineto (588.25, 244);
  w->curveto (588.25, 247.125, 585.5, 248.75, 580.25, 248.75);
  w->curveto (569.875, 248.75, 560.5, 247.75, 552, 246);
  w->lineto (552, 248.75);
  w->curveto (565.125, 251.75, 573.375, 257.5, 576.75, 266);
  w->curveto (577, 267.5, 577.625, 268.25, 578.5, 268.25);
  w->curveto (583.5, 267.875, 588.75, 265.25, 594.5, 260.5);
  w->curveto (598.625, 256.125, 600.75, 250.625, 600.75, 244);
  w->lineto (600.75, 156);
  w->lineto (700.5, 156);
  w->curveto (704.25, 156, 706.25, 154.75, 706.25, 152.25);
  w->curveto (706.25, 150.625, 704.75, 149.25, 701.75, 148);
  w->curveto (694.875, 143.875, 689.5, 139.375, 685.75, 134.5);
  w->lineto (673.25, 149.25);
  w->lineto (600.75, 149.25);
  w->lineto (600.75, 125.75);
  w->curveto (601.25, 123.5, 602, 121.875, 603.25, 121);
  w->curveto (605.5, 120.375, 606.75, 119, 606.75, 117);
  w->curveto (606.75, 116.25, 605.75, 115.5, 604, 115);
  w->curveto (625, 105.5, 646, 94.125, 667.25, 80.75);
  w->curveto (668.25, 79.5, 671.25, 78.75, 676.5, 78.5);
  w->curveto (680.75, 78, 683, 76.5, 683, 74);
  w->curveto (683, 72.375, 682, 70.875, 680, 69.5);
  w->curveto (675.75, 66.875, 671.5, 61.875, 667.25, 54.5);
  w->closepath ();

  w->fill (pen);
  w->popmatrix();
 }
}
  w->popmatrix();
}


/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 */
int
main (int argc, char* argv[])
{
  if (argc==1)
  {
    fprintf (stderr, "usage: main scale (0.05..1) [x] [y]\n");
    return 1;
  }
  if (sscanf (argv[1], "%lf", &scl) != 1)
  {
    fprintf (stderr, "usage: main scale (0.05..1) [x] [y]\n");
    return 1;
  }
  if (argc > 2) sscanf (argv[2], "%d", &maxx);
  if (argc > 3) sscanf (argv[3], "%d", &maxy);
  SAwt awt(true);
  
  if (!awt.implemented())
  {
    fprintf (stderr, "AWT is not implemented!\n");
    return 0;
  }
  SWindow* w = awt.getWindow(new Listener(), "Gaspar's WINDOW");
  //w->cacheOn (true);
  //w->setBackground (SColor(0.5, 0.6, 0.7, 1.0));
  w->setBackground (SColor(1.0, 1.0, 1.0, 1.0));
  w->resize (750, 320);
  w->show(); 
  SEventHandler::start();
  return 0;
}

#ifdef USE_WINAPI

// Hacked for winapi coming from stoolkit/SEventBSD.cpp
extern int gettimeofday (struct timeval* tv, void* tz);
#endif

static struct timeval thatTime;

void
timerStart()
{
  gettimeofday (&thatTime, 0);
}

void 
timerStop()
{
  struct timeval thisTime;
  gettimeofday (&thisTime, 0);
  if (thisTime.tv_usec < thatTime.tv_usec)
  {
    thisTime.tv_sec--;
    thisTime.tv_usec+=1000000;
  }
  thisTime.tv_sec -= thatTime.tv_sec;
  thisTime.tv_usec -= thatTime.tv_usec;
  int msec = (int) thisTime.tv_sec * 1000 + thisTime.tv_usec/1000;
  fprintf (stderr, "Elapsed time: %d msecs\n", msec);
}

