/***************************************************************************
 *
 * $Header: /usr/local/cvsroot/utils/ytree/system.c,v 1.10 2000/07/13 18:26:06 werner Exp $
 *
 * System Call
 *
 ***************************************************************************/


#include "ytree.h"




int SystemCall(char *command_line)
{
  int result;

#ifndef XCURSES
  endwin();
#endif
  result = SilentSystemCall( command_line );
  
  (void) GetAvailBytes( &statistic.disk_space );

  return( result );
}


int QuerySystemCall(char *command_line)
{
  int result;

#ifndef XCURSES
  endwin();
#endif
  result = SilentSystemCall( command_line );
  HitReturnToContinue();
  (void) GetAvailBytes( &statistic.disk_space );

  return( result );
}



extern struct itimerval value, ovalue;

int SilentSystemCall(char *command_line)
{
  int result;
#ifdef XCURSES
  char *xterm=NULL;
#endif

#ifdef CLOCK_SUPPORT
  struct itimerval value, ovalue;
#endif


  /* Hier ist die einzige Stelle, in der Kommandos aufgerufen werden! */

#if defined( __NeXT__ )
  nl();
#endif /* linux */

#ifdef CLOCK_SUPPORT
  value.it_interval.tv_sec = 0;
  value.it_value.tv_sec = 0;
  value.it_interval.tv_usec = 0;
  setitimer(ITIMER_REAL, &value, &ovalue);
  signal(SIGALRM, SIG_IGN);
#endif

#ifdef XCURSES
  if( ( xterm = malloc( strlen( command_line ) + 10 ) ) == NULL ) {
    ERROR_MSG( "Malloc Failed*ABORT" );
    exit( 1 );
  }
  sprintf(xterm, "xterm -e %s &", command_line);
  result = system( xterm );
  free(xterm);
#else
  result = system( command_line );
#endif

#ifdef CLOCK_SUPPORT
  setitimer(ITIMER_REAL, &ovalue, &value);
  signal(SIGALRM, ClockHandler);
#endif

#ifndef XCURSES
  leaveok(stdscr, TRUE);
  curs_set(0);
#if defined( __NeXT__ )
  cbreak();
  nonl();
  noecho();
  clearok( stdscr, TRUE );
#endif /* linux */ 
#endif /* XCURSES */
  
  return( result ); 
}


