#include <stdio.h>
#include <windows.h>
#include <string.h>
#include <time.h>
#include "youbin.h"
#include "w_youbin.h"
#include "resource.h"

#define M_TIMER_ID 10

typedef struct HEADER_MESSAGE{
	int message_number;
	char message[HEADER_LEN + 1 + 64];
	struct HEADER_MESSAGE *next;
	struct HEADER_MESSAGE *last;
} HEADER_MESSAGE;

struct HEADER_MESSAGE *message_list_head;
struct HEADER_MESSAGE *message_list_tail;
int message_count=0;
int disp_seconds;

int check_head_list(int head);
void mimedecode( char *source, char *dest );
void set_head_subject(char *head, char *dest);
void convert_w_message(char *mess ,char *dest);
void jis_to_sjis(char *source, char *dest);
void change_n(char *from, char *to);
BOOL CALLBACK dialog_func_message_disp(HWND hdwnd,
		UINT message, WPARAM wParam, LPARAM lParam);
void reset_mailarrive(HWND hwnd);
int get_message_open();
int get_message_close();
int get_message_disp_seconds();
int get_max_message_count();


void w_show_message(HINSTANCE g_hInstance, HWND hwnd)
{
	if(message_count != 0){
		int dlg;
		disp_seconds = -1;
		dlg = DialogBox(g_hInstance, "MESSAGE_DISP", hwnd, dialog_func_message_disp);
	}
	return;
}

void w_show_message_current(HINSTANCE g_hInstance, HWND hwnd)
{
	int dlg;

	if(!get_message_open()) return;
	if(message_count == 0) return;
	if(get_message_close()){
		disp_seconds = get_message_disp_seconds();
	}else{
		disp_seconds = -1;
	}
	dlg = DialogBox(g_hInstance, "MESSAGE_DISP", hwnd, dialog_func_message_disp);
	if(dlg == 2) reset_mailarrive(hwnd);
	return;
}

void set_w_message(char *mess)
{
	HEADER_MESSAGE *header_message;
	HEADER_MESSAGE *temp_header_message;
	char temp_message[HEADER_LEN+1+64]="";

	if(*mess == '\0') return;
	convert_w_message(mess, temp_message);
	message_count++;
	header_message = (HEADER_MESSAGE *)malloc(sizeof(HEADER_MESSAGE));
	if(message_count == 1){
		message_list_tail = header_message;
		header_message->next = NULL;
	}else{
		message_list_head->last = header_message;
		header_message->next = message_list_head;
	}
	header_message->last = NULL;
	header_message->message_number = message_count;
	strcpy(header_message->message, temp_message);
	message_list_head = header_message;

	if(message_count > get_max_message_count()){
		temp_header_message = message_list_tail;
		message_list_tail = temp_header_message->last;
		message_list_tail->next = NULL;
		free(temp_header_message);
	}
}

/*
 * numܰʹߤΥåä
 * ƬΥå 0 ܤȤ롥
 */
void remove_message(int num)
{
	int count = 0;
	HEADER_MESSAGE *current_message;
	HEADER_MESSAGE *temp_message;

	if(message_list_head == NULL) return;

	current_message = message_list_head;
    while(count < num){
		temp_message = current_message;
	current_message = temp_message->next;
		if(current_message == NULL) return;
		count++;
	}

    message_list_tail = current_message->last;

	while(current_message != NULL){
		temp_message = current_message;
		current_message = temp_message->next;
	free(temp_message);
	}

	if(message_list_tail != NULL)
	    message_list_tail->next = NULL;
}

void convert_w_message(char *mess, char *dest)
{
	char temp_message[HEADER_LEN+1]="";
	char head[256]="";
	char body[HEADER_LEN+1] = "";
	char body_after[HEADER_LEN+1]="";
	char head_date[64]="";
	int c_body, c_subject, hcount;
	int c_from, c_to, c_cc, c_date;
	int n,sn,i,h;
	hcount = 0;
	c_body = 0;
	c_subject = 0;
	c_from = 0;
	c_to = 0;
	c_cc = 0;
	c_date = 0;

    if( check_head_list(HEAD_BODY) )  c_body = 1;
    if( check_head_list(HEAD_FROM) )  {c_from = 1; hcount += 1;}
    if( check_head_list(HEAD_TO) )  {c_to = 1; hcount += 1;}
    if( check_head_list(HEAD_SUBJECT) )  {c_subject = 1; hcount += 1;}
    if( check_head_list(HEAD_CC) )  {c_cc = 1; hcount += 1;}
	if( check_head_list(HEAD_DATE) ) {c_date = 1; hcount += 1;}

	n = 0;
	for(;hcount>0;hcount--){
		i = 0;
		sn = n;
		while( (*(mess + n) != '\n') && (*(mess + n) != '\0') ){
			head[i] = *(mess + n);
			i++;
			n++;
		}
	if( *(mess + n) == '\n' ){
	    head[i] = '\r';
			head[i+1] = '\n';
			head[i+2] = '\0';
		}else{
			head[i] = '\0';
		}
		n++;
		if( c_subject ){
			if( strncmp(head,"Subject:",8) == 0 ){
				set_head_subject(head, temp_message);
				continue;
			}
		}

		h = 0;
		if( c_from && strncmp(head,"From:",5) == 0 ) h=1;
		if( c_to   && strncmp(head,"To:",3) == 0 ) h=1;
		if( c_cc   && strncmp(head,"CC:",3) == 0 ) h=1;
		if( c_date && strncmp(head,"Date:",5) == 0 ) h=1;
		if( h == 1){
			strcat(temp_message, head);
		}else{
			hcount = 0;
			n = sn;
		}
	}
	if(c_body){
		jis_to_sjis(mess+n, body);
		change_n(body,body_after);
		strcat(temp_message, body_after);
	}
	strcpy(dest, temp_message);
}

void set_head_subject(char *head, char *dest)
{
	int hi=0,di=0;
	int check=0;
	int temp1,temp2;
	int p1,p2,p3,p4;
	char mime[256]="";
	char jis[256]="";
	char sjis[256]="";
	char temp[256]="";

	while( *(head+hi) != '\0' ){
		if(check==0){
			if( *(head+hi) == '=' ){
				temp1=strncmp( head+hi,"=?ISO-2022-JP",13);
				temp2=strncmp( head+hi,"=?iso-2022-jp",13);
				if( temp1==0 || temp2==0 ){
					p1 = hi-1;
					hi += 13;
					check=1;
				}else{
					hi++;
				}
			}else{
				hi++;
			}
		}else if(check==1){
			if( *(head+hi) == '?' ){
				temp1=strncmp( head+hi,"?B?",3);
				temp2=strncmp( head+hi,"?b?",3);
				if( temp1==0 || temp2==0 ){
					hi += 3;
					p2 = hi;
					check=2;
				}else{
					hi++;
				}
			}else{
				hi++;
			}
		}else if(check==2){
			if( *(head+hi)=='=' || *(head+hi)=='?' ){
				p3 = hi-1;
				while( *(head+hi)=='=' || *(head+hi)=='?' ){
					if( *(head+hi)=='?' && strncmp( head+hi,"?=",2)==0 ){
						hi += 2;
						p4 = hi;
						check=3;
					}else{
						hi++;
					}
				}
			}else{
				hi++;
			}
		}else{
			hi++;
		}
	}

	if( check == 3 ){
		strncpy(mime,head+p2,p3-p2+1);
		mime[p3-p2+1]='\0';
		mimedecode( mime, jis );
		jis_to_sjis( jis,sjis );
		strncat(temp,head,p1+1);
		strcat(temp,sjis);
		strcat(temp,head+p4);
		strcat(dest, temp);
	}else{
		strcat(dest, head);
	}

}

void jis_to_sjis(char *source, char *dest)
{
	int si,di,mode;
    char temp[HEADER_LEN + 1] = "";
	unsigned char c1,c2;

	si = 0;
	di = 0;
	mode = 0;
/* siʸ¡ʽλȽ˼ԤΤ */
	while( (*(source+si) != '\0') && si<1000){
		if( (si > 0) && (*(source+si-1) == '\0') ) break;
		if( *(source+si) == 0x1B ){
			c1 = *(source+si+1);
			if( c1 != '\0' ){
				c2 = *(source+si+2);
				if( c2 != '\0' ){
					if( (c1 == 0x24 && c2 == 0x42) || (c1 == 0x24 && c2 == 0x40) ){
						mode = 1;
						si += 3;
						continue;
					}else if( (c1 == 0x28 && c2 == 0x4A) || (c1 == 0x28 && c2 == 0x42) ){
						mode = 0;
						si += 3;
						continue;
					}
				}
			}
		}
		if(mode == 1){
			c1=*(source+si);
			c2=*(source+si+1);

			if(c1 & 0x01){
				c1 = ((c1 + 0x01) / 2) + 0x70;
				c2 = c2 + 0x1F;
			}else{
				c1 = (c1 / 2) + 0x70;
				c2 = c2 + 0x7D;
			}
			if(c1 >= 0xA0)	c1 = c1 + 0x40;
			if(c2 >= 0x7F)	c2 = c2 + 0x01;

			temp[di]=c1;
			temp[di+1]=c2;

			di+=2;
			si+=2;
			temp[di]='\0';
		}else{
			temp[di] = *(source + si);
			di++;
			si++;
		}
	}
	temp[di] = '\0';
	strcpy(dest,temp);
}

void change_n(char *from, char *to)
{
	int f=0;
	int t=0;
	char c;

	c = *(from + f);
	while(c != '\0'){
		if(c == '\n'){
			*(to + t) = '\r';
			*(to + t + 1) = '\n';
			t += 2;
	}else{
			*(to + t) = c;
			t++;
		}
		f++;
		c = *(from + f);
	}
	*(to + t) = '\0';
}

void disp_to_editbox(HWND hdwnd, struct HEADER_MESSAGE *mess)
{
	char disp_message[HEADER_LEN+1+32]="";
	int mc;

	mc = get_max_message_count();
	if(message_count <= mc){
		mc = 1;
    }else{
	mc = message_count - mc + 1;
	}
	sprintf(disp_message, "Message %d / %d-%d\r\n%s", mess->message_number,
		    mc, message_count, mess->message);
	SetDlgItemText(hdwnd, IDC2_EBX_MESSAGE_DISP, disp_message);
}

BOOL CALLBACK dialog_func_message_disp(HWND hdwnd,
		UINT message, WPARAM wParam, LPARAM lParam)
{
static int t;
static struct HEADER_MESSAGE *current_message;
	switch(message){
	case WM_INITDIALOG:
	SetWindowPos(hdwnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE | SWP_NOSIZE);
		current_message = message_list_head;
		disp_to_editbox(hdwnd, current_message);
		t = disp_seconds;
		if(t >= 0) SetTimer( hdwnd, M_TIMER_ID, 1000, NULL);
		return 1;
	case WM_TIMER:
		{
			char disp_time[36];

			sprintf(disp_time,"å %d ø˾äޤ",t);
			SetWindowText(hdwnd, disp_time);
			if(t <= 0){
				KillTimer( hdwnd, M_TIMER_ID );
				EndDialog(hdwnd, 1);
				return 1;
			}
			t--;
			return 1;
		}
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDC2_BTN_OK:
			EndDialog(hdwnd, 2);
			return 1;
		case IDC2_BTN_NEXT:
			if(current_message->next != NULL){
				current_message = current_message->next;
				disp_to_editbox(hdwnd, current_message);
			}
			return 1;
		case IDC2_BTN_LAST:
			if(current_message->last != NULL){
				current_message = current_message->last;
				disp_to_editbox(hdwnd, current_message);
			}
			return 1;
		case IDC2_BTN_CLEAR:
			remove_message(0);
			message_count = 0;
			EndDialog(hdwnd, 2);
			return 1;
		}
	}
	return 0;
}
