
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include "lib.h"

#ifndef EXTERN			/* EXTERN variables will be */
#define EXTERN extern		/* either declared or defined */
#endif

typedef enum			/* lexical analyzer tokens */
  {
    tok_eof,
    tok_space,
    tok_symbol,
    tok_string,
    tok_anychar,
    tok_newline,
    tok_openpar,
    tok_closepar,
  }
TOKEN;

EXTERN TOKEN
  lextok;			/* current lexer token */
EXTERN char
 *lexbuf,			/* buffer for lexical analyzer */
 *lexer_pushed,			/* pre-pushed input */
 *lexer_pushedp;		/* ptr into lexer_pushed */

struct Builtin
  {
    char const* name;
    void (*func)(void);
  };

struct Builtin* builtin_find (char const* name);
#if 0
char* builtin_get (int i);
#else
#define builtin_get(x) builtin[x]
#endif

#include "builtins.h"

EXTERN char
**builtin;			/* table of builtin macros */
EXTERN int
  nbuiltin;			/* size of table */

typedef char *CHARTAB[256];	/* one table: 256 char->string */

EXTERN CHARTAB
* chartab,			/* the char tables themselves */
 *curchartab;			/* currently used char table */
EXTERN int
  nchartab;			/* # of defined char tables */
EXTERN char
**chartabname;			/* names of char tables */

EXTERN CHARTAB
** chartabstack;		/* char table stack */
EXTERN int
  nchartabstack;		/* size of char table stack */

EXTERN char
**userdef,			/* table of user-defined macros */
**definition;			/* and the redef */
EXTERN int
 *narg;				/* # of args in the macro */
EXTERN int
  nuserdef;			/* size of table */

EXTERN char			/* storage of defined symbols */
**define;
EXTERN int
  ndefine;

EXTERN FILE
 *inf,				/* input file */
 *outf;				/* where the output goes */

EXTERN char
 *outfname;			/* name of final output file */
EXTERN int
  last_written_char;		/* last written character */

EXTERN char
 *cur_input_file;		/* name of input file */
EXTERN int
  cur_lineno;			/* and linenumber in it */

					    /* macros to access last two */
EXTERN int
  verbose,			/* verbosity level, 0-4 */
  maxpass;			/* max nr of allowed passes */

EXTERN char
 *stdinclude;			/* directory for includes */

EXTERN char
**atexit_strings;		/* strings to parse at exit */
EXTERN int
  natexit_strings;

EXTERN char
**subst,			/* sources for SUBST commands */
**subst_redef;			/* redefinitions */
EXTERN int
  nsubst;			/* size of subst tables */

typedef struct Flags		/* general working flags */
  {
    int
      trace_output:1,		/* trace generated output? */
      warn:1;			/* generate warnings? */
  }
FLAGS;

EXTERN FLAGS
  flags;

EXTERN int
  in_def;			/* inside START/ENDDEF()? */

EXTERN char
**countername;			/* table of counter names */
EXTERN int
  ncountername;			/* table size */
EXTERN int
 *counterval;			/* counter values */

EXTERN char
**nousermacro;			/* table of no-user-macro's */
EXTERN int
  nnousermacro;

EXTERN int
  livedata;			/* live data policy */

extern int check_live_data (char const *macro, char const *cmd);
extern void gnu_vmessage (char const* format, va_list args);
extern void gnu_message (char const *format, ...);
extern void gnu_vwarning (char const* format, va_list args);
extern void gnu_warning (char const *format, ...);
extern void error_gram (char const *gramrule, char const *msg,...);
extern void error_no_memory (void);
extern void error_output_write (void);
extern void file_close (FILE * f);
extern char *file_expandname (char const *barename);
extern int file_isfile (char const *fname);
extern void gram_atexit (void);
extern char* gram_do_expand (char* str);
EXTERN int dont_do_expand_global;
extern int gram_try_expand (void);
extern int gram_findcounter (char const *rule, char const *name);
extern int gram_getchar (void);
extern int gram_hasident (char const *buf);
extern void gram_onename (char const *gramsym, char const *parlist);
extern int gram_onenumber (char const *gramsym, char const *parlist);
extern char *gram_parlist (char const *gramsym, int expand_char);
extern void gram_subst (void);
extern void gram_symbol (void);
extern void gram_warn (char const *symbol, char const *msg,...);
extern int isIdentChar (int ch);
extern void init (void);
extern void lexer (void);
extern int lexer_eof (void);
extern int lexer_getc (void);
extern int lexer_peek (void);
extern void lexer_pushchar (int ch);
extern void lexer_pushstr (char const *s);
extern void lexer_preread (void);
extern void message (int lev, char const *fmt,...);
extern void output_string (char const *s);
extern void output_symbol (char const *sym);
extern void parse (void);
extern void parse_cycle (void);
extern void parse_flags (int ac, char **av);
extern void showchildstatus (int status, char const *cmd);
extern int subst_mightbe (char const *buf);
extern void symbol_add (char const *symname);
extern void usage ();
extern int userconfirm (char const *msg);
extern void sighandler (int sig);
extern void version ();

/* Here's for SYSTEMs that don't have sterror(): */
#ifdef NEEDSTRERROR
extern int errno;
extern char *strerror (int err_number);
#endif

/* Same for SYSTEMs that don't have optind, optarg, etc.. */
#ifdef NEEDOPT
extern int optind, opterr;
extern char *optarg;
#endif
