#ifndef __PORT_SIGNAL_H
#define __PORT_SIGNAL_H
#endif

#ifdef __PORT_SIGNAL_H

#define BASE 0x378
#define DATA (BASE)
#define ECPAFIFO (BASE)
#define DSR (BASE+1)
#define DCR (BASE+2)
#define CFIFO (BASE+0x400)
#define ECPDFIFO (BASE+0x400)
#define TFIFO (BASE+0x400)
#define CNFGA (BASE+0x400)
#define CNFGB (BASE+0x401)
#define ECR (BASE+0x402)

#define DIRWAIT  usleep(1000)

#define DSR_NBUSY	0x80
#define DSR_NACK	0x40
#define DSR_PE		0x20
#define DSR_SELECT	0x10
#define DSR_NERROR	0x08

#define DCR_DIRECTION	0x20
#define DCR_ACKINTEN	0x10
#define DCR_NSELECTIN	0x08
#define DCR_NINIT	0x04
#define DCR_NAUTOFEED	0x02
#define DCR_NSTROBE	0x01

#define ECR_MODE_SPP		0x00
#define ECR_MODE_EPP		0x20
#define ECR_MODE_SPP_FIFO	0x40
#define ECR_MODE_ECP		0x60
#define ECR_MODE_CONF		0xe0

#define ECR_NERRINTREN		0x10
#define ECR_DMAEN		0x08
#define ECR_SERVICEINTR		0x04
#define ECR_FULL		0x02
#define ECR_EMPTY		0x01

#define HIGH			1
#define LOW			0

#define NONE			0

#endif //__PORT_SIGNAL_H
