/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#include <utility>

#include "yehia/script/class-builder.h"

namespace Yehia
{

namespace Script
{

using namespace std;

ClassBuilder_::ClassBuilder_(ObjectFactory& factory, 
                             Namespace& parent_ns, 
                             const std::string& name, 
                             const Signature& bases)
    : factory_(factory), parent_ns_(parent_ns)
{
  name_ = name;
  constructor_ = 0;
  
  classobj_ = &factory_.create_class(bases);
  this_class_ = classobj_->class_interface();
  
  parent_ns_.insert(name_, *classobj_);
}

ClassBuilder_::~ClassBuilder_()
{
}

void ClassBuilder_::add_constructor(const Slot& slot, const Signature& sig)
{
  if (!constructor_)
  {
    Object& genfunc = factory_.create_genfunc();
    constructor_ = genfunc.genfunc_interface();
    this_class_->set_constructor(genfunc);
  }
  constructor_->add_method(slot, sig);
}

void ClassBuilder_::add_method(const std::string& name, const Slot& slot, 
                               const Signature& sig)
{
  std::map<std::string, GenFunc *>::iterator it = method_map_.find(name);
  
  if (it != method_map_.end())
    (*it).second->add_method(slot, sig);
  else
  {
    Object& funcobj = factory_.create_genfunc();
    GenFunc *genfunc = funcobj.genfunc_interface();
    genfunc->add_method(slot, sig);
    method_map_.insert(make_pair(name, genfunc));

    this_class_->add_genfunc(name, funcobj);
  }
}

void ClassBuilder_::add_class_method(const std::string& name, const Slot& slot,
                                     const Signature& sig)
{
  std::map<std::string, GenFunc *>::iterator it = class_method_map_.find(name);
  
  if (it != class_method_map_.end())
    (*it).second->add_method(slot, sig);
  else
  {
    Object& funcobj = factory_.create_genfunc();
    GenFunc *genfunc = funcobj.genfunc_interface();
    genfunc->add_method(slot, sig);
    class_method_map_.insert(make_pair(name, genfunc));

    this_class_->add_class_genfunc(name, funcobj);
  }
}

void ClassBuilder_::add_setter(const string& name, const Slot& slot, 
                               const Signature& sig)
{
  std::map<std::string, GenFunc *>::iterator it = setter_map_.find(name);
  
  if (it != setter_map_.end())
    (*it).second->add_method(slot, sig);
  else
  {
    Object& funcobj = factory_.create_genfunc();
    GenFunc *genfunc = funcobj.genfunc_interface();
    genfunc->add_method(slot, sig);
    setter_map_.insert(make_pair(name, genfunc));

    this_class_->add_setter(name, funcobj);
  }
}

void ClassBuilder_::add_getter(const type_info& ti, 
                               const string& name, const Slot& slot)
{
  Signature sig;
  std::map<std::string, GenFunc *>::iterator it = getter_map_.find(name);
  
  sig.push_back(&ti);

  if (it != getter_map_.end())
    (*it).second->add_method(slot, sig);
  else
  {
    Object& funcobj = factory_.create_genfunc();
    GenFunc *genfunc = funcobj.genfunc_interface();
    genfunc->add_method(slot, sig);
    getter_map_.insert(make_pair(name, genfunc));

    this_class_->add_getter(name, funcobj);
  }
}


}

}
