/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#include "yehia/script/base.h"

namespace Yehia
{

namespace Script
{

using namespace std;

void Object::unreference()
{
  if (refcnt_ && --refcnt_ == 0)
    factory_.destroy(*this);
}

Object::~Object()
{
}

Namespace *Object::namespace_interface()
{
  return 0;
}

Instance *Object::instance_interface()
{
  return 0;
}

Function *Object::function_interface()
{
  return 0;
}

GenFunc *Object::genfunc_interface()
{
  return 0;
}

Class *Object::class_interface()
{
  return 0;
}

ObjectFactory::ObjectFactory()
{
  class_hash_ = g_hash_table_new(&g_str_hash, &g_str_equal);
}

ObjectFactory::~ObjectFactory()
{
  g_hash_table_destroy(class_hash_);
}

void ObjectFactory::register_class(const std::type_info& ti, Object& klass)
{
  g_hash_table_insert(class_hash_, (gpointer)ti.name(), (gpointer)&klass);
}

Object *ObjectFactory::find_class(const std::type_info& ti)
{
  return (Object *)g_hash_table_lookup(class_hash_, ti.name());
}

Language::Language(Namespace& ns, ObjectFactory& fact, SigCX::Tunnel *t) 
    : ns_(ns), fact_(fact), tunnel_(t)
{
}

Language::Language(const Language& l) 
    : ns_(l.ns_), fact_(l.fact_), tunnel_(l.tunnel_)
{
}

Language& Language::operator=(const Language& l) 
{
  ns_ = l.ns_;
  fact_ = l.fact_;
  tunnel_ = l.tunnel_;
  
  return *this;
}

LanguageManager *LanguageManager::instance_ = 0;

LanguageManager::LanguageManager(ErrorHandler *parent, 
                                 SigCX::Tunnel *main_tunnel)
    :  ErrorHandler(parent), main_tunnel_(main_tunnel)
{
  if (instance_)
    throw std::runtime_error("an instance of LanguageManager already exists");
  
  instance_ = this;
}

LanguageManager& LanguageManager::instance()
{
  if (!instance_)
    instance_ = new LanguageManager();

  return *instance_;
}

Language *LanguageManager::language(const Script::ObjectFactory& factory)
{
  std::map<string, Script::Language *>::const_iterator it;
  
  for (it = languages_.begin(); it != languages_.end(); ++it)
    if (it->second->factory() == factory)
      return it->second;

  return 0;
}

list<Script::Language *> LanguageManager::languages() const
{
  list<Script::Language *> result;
  std::map<string, Script::Language *>::const_iterator it;
  
  for (it = languages_.begin(); it != languages_.end(); ++it)
    result.push_back((*it).second);
  
  return result;
}

list<string> LanguageManager::language_names() const
{
  list<string> result;
  std::map<string, Script::Language *>::const_iterator it;
  
  for (it = languages_.begin(); it != languages_.end(); ++it)
    result.push_back((*it).first);
  
  return result;
}

void LanguageManager::register_language(const string& name, 
                                      Script::Language& lang)
{
  languages_.insert(pair<string, Script::Language *>(name, &lang));
  language_registered.emit(name);
}

}

}

