#!/bin/sh
# File:		apache-php.sh
# Changes:
#	20010219 Ola Lundqvist <opal@debian.org>
#	20011022 Luca De Vitis <luca@debian.org>
#		Introduced the error variable.
#	        o /[[:space:]][[:space:]]*/[[:space:]]\+/
#	        o /  */[[:space:]]\+/
#	        o / */[[:space:]]*/
#	20020116 Ola Lundqvist <opal@debian.org>
#		Documented the error variable.
# Needs:	$phpver - the php version to use.
#		$phpini - the php config file to use.
#		$server - the apache server to use,
#			anything that matches /etc/$server/*.conf
# Description:	Verifies that the php module is loaded in the apache config file.
# Sets:		$status = {error, nothing, include, uncomment}
#		$error = error message (if $status = error)

status=error
error=""

if [ -z "$phpver" ] ; then
    error="No php version to check for."
elif [ -z "$phpini" ] ; then
    error="No php ini file to check for."
elif [ ! -f $phpini ] ; then
    error="Php config file $phpini not found."
else
    phpverm=$phpver"_module"
    if grep -e "^[[:space:]]*#[[:space:]]*LoadModule[[:space:]]\+$phpverm" /etc/$server/httpd.conf > /dev/null 2>&1; then
		# Uncommenting
	sed -e "s#\([[:space:]]*\)\#[[:space:]]\+\(LoadModule $phpverm\)#\1\2#" /etc/$server/httpd.conf > /etc/$server/httpd.conf.tmp
	status=uncomment
	if grep -e "^[[:space:]]*LoadModule[[:space:]]\+$phpverm" /etc/$server/httpd.conf.tmp >/dev/null 2>&1; then
			# Uncomment successful.
	    cp /etc/$server/httpd.conf /etc/$server/httpd.conf.back >/dev/null 2>&1
	    mv /etc/$server/httpd.conf.tmp /etc/$server/httpd.conf
	else
			# Uncomment unsuccessful.
	    status=error
	    rm /etc/$server/httpd.conf.tmp
	fi
    fi
fi
