/*

  These routines are originally from the sox.c and utils.c files in the sox src directory.
  Original authors and copyright holders :
   * July 5, 1991
   * Copyright 1991 Lance Norskog And Sundry Contributors
   * June 1, 1998 - Chris Bagwell (cbagwell@sprynet.com)
   AND now Matt Flax is flatmax as MFFM
	
   Copyright 2001-2005 Matt Flax is flatmax as MFFM <flatmax@Matt.Flax.mffm>
   This file is part of MFFM Time Scale Modification for Audio.

   MFFM Time Scale Modification for Audio is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM Time Scale Modification for Audio is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM Time Scale Modification for Audio
 */

#ifndef SOXROUTINES_H_
#define SOXROUTINES_H_

#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

//char *myname = 0;

/* Warning: no error checking is done with errstr.  Be sure not to
 * go over the array limit ourself!  vsnprint does not seem to be
 * on all platforms so not using that.
 */
void st_fail_errno(ft_t ft, int st_errno, const char *fmt, ...)
{
        va_list args;

        ft->st_errno = st_errno;

        va_start(args, fmt);
        vsprintf(ft->st_errstr, fmt, args);
        va_end(args);
        ft->st_errstr[255] = '\0';
}


int strcmpcase(const char *s1, const char *s2)
{
	char *str1;
	char *str2;
	int res;
	unsigned int i;

	if ((str1=strdup(s1)) == NULL)
		return 1;

	if ((str2=strdup(s2)) == NULL)
		return 1;

	for (i = 0; i < strlen(str1); i++)
		str1[i] = tolower(str1[i]);

	for (i = 0; i < strlen(str2); i++)
		str2[i] = tolower(str2[i]);

	res = strcmp(str1, str2);

	free(str1);
	free(str2);

	return res;
}

/*ft_t st_initformat(void)
{
    ft_t ft;

    ft = (ft_t)calloc(sizeof(struct st_soundstream), 1);

    ft->info.size = -1;
    ft->info.encoding = -1;
    ft->info.channels = -1;

    return ft;
}*/

/*
 * Check that we have a known format suffix string.
 */
/*int st_gettype(ft_t formp)
{
        char **list;
        int i;

        if (! formp->filetype){
            st_fail_errno(formp,
                          ST_EFMT,
                          "Filetype was not specified");
                return(ST_EFMT);
        }
        for(i = 0; st_formats[i].names; i++) {
                for(list = st_formats[i].names; *list; list++) {
                        char *s1 = *list, *s2 = formp->filetype;
                        if (! strcmpcase(s1, s2))
			break;  // not a match
                }
                if (! *list)
                        continue;
			// Found it!
                formp->h = &st_formats[i];
                return ST_SUCCESS;
        }
        st_fail_errno(formp, ST_EFMT, "File type '%s' is not known",
                      formp->filetype);
        return ST_EFMT;
}*/

/* check that all settings have been given */
/*int st_checkformat(ft_t ft)
{

        ft->st_errno = ST_SUCCESS;

        if (ft->info.rate == 0)
        {
                st_fail_errno(ft,ST_EFMT,"sampling rate was not specified");
                return ST_EOF;
        }

        if (ft->info.size == -1)
        {
                st_fail_errno(ft,ST_EFMT,"data size was not specified");
                return ST_EOF;
        }

        if (ft->info.encoding == -1)
        {
                st_fail_errno(ft,ST_EFMT,"data encoding was not specified");
                return ST_EOF;
        }

        if ((ft->info.size <= 0) || (ft->info.size > ST_INFO_SIZE_MAX))
        {
                st_fail_errno(ft,ST_EFMT,"data size %i is invalid");
                return ST_EOF;
        }

        // anyway to check length on st_encoding_str[] ?
        if (ft->info.encoding <= 0  || ft->info.encoding > ST_ENCODING_MAX)
        {
                st_fail_errno(ft,ST_EFMT,"data encoding %i is invalid");
                return ST_EOF;
        }

        return ST_SUCCESS;
}*/

//void cleanup(void){
//}

/* called from util.c::st_fail() */
void st_fail(const char *fmt, ...)
{
        va_list args;

        fprintf(stderr, "%s: ", myname);

        va_start(args, fmt);
        vfprintf(stderr, fmt, args);
        va_end(args);
        fprintf(stderr, "\n");
	//cleanup();
//        exit(2);
}

#include <sys/stat.h>

static int filetype(int fd)
{
        struct stat st;

        fstat(fd, &st);

        return st.st_mode & S_IFMT;
}

void st_warn(const char *fmt, ...)
{
        va_list args;

        fprintf(stderr, "%s: ", myname);
        va_start(args, fmt);

        vfprintf(stderr, fmt, args);
        va_end(args);
        fprintf(stderr, "\n");
}

static void open_input(ft_t ft)
{
    /* Open file handler based on input name.  Used stdin file handler
     * if the filename is "-"
     */
    if (!strcmp(ft->filename, "-"))
        ft->fp = stdin;
    else if ((ft->fp = fopen(ft->filename, "rb")) == NULL)
        st_fail("Can't open input file '%s': %s", ft->filename,
                strerror(errno));

    /* See if this file is seekable or not */
#if     defined(DUMB_FILESYSTEM)
    ft->seekable = 0;
#else
    ft->seekable = (filetype(fileno(ft->fp)) == S_IFREG);
#endif
}
#endif SOXROUTINES_H_

