/* ownop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: ownop.h,v 1.6 2002/02/10 00:37:45 ralf Exp $ */

#ifndef OWNOP_H
#define OWNOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>
#include <aguix/stringgadget.h>

class Worker;

class OwnOp:public FunctionProto
{
public:
  OwnOp(Worker*);
  virtual ~OwnOp();
  virtual OwnOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual int load(Datei*);
  virtual const char *getDescription();
  virtual int configure();

  typedef enum {OWNOP_START_NORMAL=0,
                OWNOP_START_IN_TERMINAL,
                OWNOP_START_IN_TERMINAL_AND_WAIT4KEY,
                OWNOP_SHOW_OUTPUT} ownstart_t;
  void setWithApo(bool);
  void setSeparateEachEntry(bool);
  void setRecursive(bool);
  void setOwnStart(ownstart_t);
  void setComStr(const char*);
  void setInBackground( bool );
protected:
  static const char *name;
  // Infos to save
  bool withapo;
  bool separate_each_entry;
  bool recursive;
  bool inbackground;
  
  ownstart_t ownstart;

  char *com_str;
  char *view_str;
  
  // temp variables
  Lister *startlister,*endlister;
  
  int normalmodeown();
  char *getFlag();
};

#endif
