/* locale.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: locale.h,v 1.47 2002/02/28 00:14:46 ralf Exp $ */

#ifndef LOCALE_H
#define LOCALE_H

#include "wdefines.h"
#include <aguix/lowlevelfunc.h>
#include "datei.h"

#define CATENTRY 446
#define CATCOMENTRY 43
#define CATFLAGENTRY 38

class Locale {
public:
  Locale();
  ~Locale();
//  void init(const char*);
  int loadLanguage(const char*);
  void freeLanguage();
  char *getLocale(int);
  char *getLocaleCom(int);
  char *getLocaleFlag(int);
private:
  char **catalog;
  char **catalogcom;
  char **catalogflag;
  
  void initBuiltinLang();
  void parse(Datei*,int);
  int openCatFile(Datei*file,const char *name,const char *ext);
};

extern Locale catalog;

#endif

