/* copyop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: copyop.h,v 1.13 2002/01/05 23:47:13 ralf Exp $ */

#ifndef COPYOP_H
#define COPYOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>
#include <aguix/bevelbox.h>

class CopyOp:public FunctionProto
{
public:
  CopyOp(class Worker*);
  virtual ~CopyOp();
  virtual CopyOp *duplicate();
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual int load(Datei*);
  virtual const char *getDescription();
  virtual int configure();

  int doconfigure(int mode);

  typedef enum {COPYOP_OVERWRITE_NORMAL=0,COPYOP_OVERWRITE_ALWAYS,COPYOP_OVERWRITE_NEVER} overwrite_t;
  typedef enum {COPYOP_NORMALCOPY=0,COPYOP_FASTCOPY,COPYOP_FASTESTCOPY} fastcopy_t;
  void setFollowSymlinks(bool);
  void setMove(bool);
  void setRename(bool);
  void setSameDir(bool);
  void setRequestDest(bool);
  void setRequestFlags(bool);
  void setOverwrite(overwrite_t);
  void setPreserveAttr(bool);
protected:
  static const char *name;
  // Infos to save
  bool follow_symlinks;
  bool move;
  bool do_rename;
  bool same_dir;
  bool request_dest;
  bool preserve_attr;
  bool request_flags;

  overwrite_t overwrite;

  fastcopy_t fastcopy;

  char *cp_com[2]; /* extern cp-progs, [0] for normal copy, [1] for forcing overwrite
                      normally no need to change because the "cp" should everywhere ok, but
                      if the user want to */
  
  // temp variables
  Lister *startlister,*endlister;
  
  // temp values filled when request_flags==true
  bool tfollow_symlinks;
  bool tmove;
  bool trename;
  bool tsame_dir;
  bool trequest_dest;
  bool tpreserve_attr;
  overwrite_t toverwrite;
  fastcopy_t tfastcopy;
  char *tcp_com[2];

  int normalmodecopy();
  int requestdest(char *defaultstr,char **dest);
};

class CopyOpWin
{
public:
  CopyOpWin(AGUIX*);
  ~CopyOpWin();
  int open(bool slim);
  void close();
  void starttimer(); // called once to set timer
  void stoptimer();  // when user-action is needed
  void conttimer();  // when user-interaction finished
  // called once:
  void set_files_to_copy(long nfiles);
  void set_dirs_to_copy(long ndirs);
  void set_bytes_to_copy(loff_t nbytes);
  // calld after newfile()
  void set_bytes_to_copy_actfile(loff_t nbytes);
  
  void dir_finished();
  void file_finished();
  // called when a block from the actual file is copied
  void add_actbytes_copied(loff_t nbytes);
  // called when start a new file
  void newfile(char *name,char *ndest);
  // for setting a message in the two lines used for display copy source/dest
  void setmessage(char *msg,int line);
  // for dec file/dir-counter (mainly in case of skiped files/dirs
  void dec_file_counter(unsigned long f);
  void dec_dir_counter(unsigned long d);
  void dec_byte_counter(loff_t b);

  /* should be called in copy-loop
   * does the update of the window AND process X-events
   * returnvalues: 0 - normal exists
   *               1 - cancel/close window pressed */ 
  int redraw();
  void forceredraw();
protected:
  char *source;
  char *dest;
  loff_t copied_bytes_actfile,bytes_actfile;
  loff_t copied_bytes,bytes;
  long copied_files,files;
  long copied_dirs,dirs;
  time_t starttime;
  time_t filestarttime;
  time_t stoptime;
  int sbw;
  
  bool slim;
  
  AGUIX *aguix;
  AWindow *window;
  Text *sourcetext,*desttext,*filetext,*globtext,*files2gotext,*dirs2gotext,*timetext;
  SolidButton *fsb,*gsb;
  BevelBox *bb1, *bb2, *bb3, *bb4;
  Button *cb;
  bool update_sourcetext,update_desttext,update_filetext,update_globtext,update_files2gotext;
  bool update_dirs2gotext;
  int melw;
  int filenamespace[2];
  
/* actual displayed infos:
   1.source (only filename)
   2.destination (whole path)
   3.progressbar for actual file
   4.<copied Bytes>/<bytes> @ <rate>
   5.files 2 copy
   6.dirs 2 copy
   7.progressbar for the whole operation
   8.<copied Bytes>/<bytes> @ <rate>
*/
};

#endif
