/* fieldlistview.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: fieldlistview.h,v 1.4 2002/04/06 22:26:21 ralf Exp $ */

#ifndef NEWLISTVIEW_H
#define NEWLISTVIEW_H

#include <string>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include "util.h"
#include "guielement.h"
#include "aguixdefs.h"

class AGUIX;
class AGUIXFont;

class FieldListView:public GUIElement
{
public:
  FieldListView( AGUIX *aguix, int x, int y, int width, int height, int data );
  virtual ~FieldListView();
  void setNrOfFields( int nv );
  void setText( int row, int field, std::string text );
  void trimElements();
  void setFieldWidth( int field, int width );
  void setSize( int rows ); // create/delete needed rows
  int getUsedWidth( int field );
  int addRow();
  int deleteRow( int row );
  int insertRow( int row );
  void swapRows( int row1, int row2 );

  void setXOffset( int nv );
  int getMaxTextWidth();
  void setYOffset( int nv );

  typedef enum { ALIGN_LEFT, ALIGN_RIGHT } align_t;

  void setFieldAlign( int field, align_t nv );

  virtual void redraw();
  void redraw( int element );
  void redrawContent();
  typedef enum { CC_NORMAL = 0, CC_SELECT = 1, CC_ACTIVE = 2, CC_SELACT = 3 } colorclass_t;
  void setFG( int row, colorclass_t cc, int col );
  int getFG( int row, colorclass_t cc );
  void setBG( int row, colorclass_t cc, int col );
  int getBG( int row, colorclass_t cc );
  void setSelect( int row, bool nv );
  void setSelectQ( int row, bool nv );
  bool getSelect( int row );
  void setActiveRow( int nv );
  void setActiveRowQ( int nv );
  int getActiveRow();

  virtual void resize( int w, int h );
  int getData();
  void setData( int );
  virtual void flush();
  virtual bool handleMessage( XEvent *E, Message *msg );
  int getXOffset();
  int getYOffset();
  virtual void setParent( AWindow *parent );
  int getElements();
  int getMaxLen();
  int getMaxDisplayV();
  int getMaxDisplayH();
  void setHBarState( int state );
  void setVBarState( int state );
  int getHBarState();
  int getVBarState();
  void setVBarWidth( int new_width );
  int getVBarWidth();
  void setHBarHeight( int new_height );
  int getHBarHeight();
  void scrollV( int delta );
  void scrollV1( int dir );
  void setSelectHandler( void (*nsh)( FieldListView*, int element ) );
  void showActive();
  void centerActive();
  int setFont (char* );
  virtual const char *getType();
  virtual bool isType( const char *type );
  virtual bool isParent( Window );
  int getRowHeight();
  int getMBG();
  void setMBG( int color );
  
  int maximizeX();
  int maximizeY();

  void showRow( int row );
  
  void setData( int row, int ndata );
  int getData( int row );
  
  bool isValidRow( int row );

  typedef enum { PRECOLOR_NORMAL, PRECOLOR_ONLYSELECT, PRECOLOR_ONLYACTIVE } precolor_t;
  void setPreColors( int row, precolor_t mode );
protected:
  int fields;
  int *fieldwidth;
  int *used_width;

  align_t *fieldalign;

  class Content
  {
  public:
    Content();
    ~Content();
    void setText( int field, std::string text );
    void trim( int fields );
    std::string getText( int field );
    int getLength( int field );
    void setFG( colorclass_t cc, int col );
    int getFG( colorclass_t cc );
    void setBG( colorclass_t cc, int col );
    int getBG( colorclass_t cc );
    void setSelect( bool nv );
    bool getSelect();
    void setData( int ndata );
    int getData();
  protected:
    int cur_fields;
    std::string **texts;

    int fg[4], bg[4];
    bool select;
    int data;
  };
  Content **elementarray;
  int arraysize;
  int elements;

  void increaseArray( int newsize );
  void checkShrink();

  int xoffset, yoffset, maxdisplayh, maxdisplayv;

  void redraw( int element, char *line );
  int activerow;

  int data;
  static const char *type;
  bool bgset;
  int hbar;
  int hbar_height;
  int hbar_dir;
  bool hbar_pressed;
  int vbar;
  int vbar_width;
  int vbar_dir;
  bool vbar_pressed;
  void mredraw();
  void hbarredraw();
  void vbarredraw();
  Window *subwins;
  Window hbarwin,vbarwin;
  int *winbgs;
  void setupsubwins();
  void rebuildSubWins( int oldsize );
  void reconfSubWins();
  void handleExpose( Window msgwin );
  virtual void handleSelect( Message *msg );
  virtual void handleMiddle( Message *msg );
  void handleThird( Message *msg );
  bool handleHBar( Message *msg );
  bool handleVBar( Message *msg );
  bool handleKeys( Message *msg );
  void (*selecthandler)( FieldListView*,int element );
  void setupBars();
  virtual void runSelectHandler( int element );
  void recalcMaxValues();
  
  AGUIXFont *font;
  struct timeval lastwheel;
  int mbg;
};

#endif
