/* fileviewer.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef FILEVIEWER_HH
#define FILEVIEWER_HH

#include "wdefines.h"
#include <string>
#include <list>
#include <aguix/refcount.hh>

class FileViewer
{
public:
  FileViewer();
  ~FileViewer();
  FileViewer( const FileViewer &other );
  FileViewer &operator=( const FileViewer &other );

  void view( const std::list<std::string> &filelist, int initial_line_number = 0, bool highlight_initial_line = false );
  static void setLineWrap( bool nv );
  static bool getLineWrap();
  static void setShowLineNumbers( bool nv );
  static bool getShowLineNumbers();
protected:
  int buildTextView( const std::string &filename,
                     class TextStorageFile **ts,
                     class TextView **tv,
                     class AContainer *ac1,
                     class Text *fnt,
                     const RefCount<class AWidth> &lencalc,
                     RefCount<class SearchTextStorage> *ts_search );
  static bool last_wrap_mode;
  static bool last_showlinenumbers_mode;
  void jumpToLine( class TextView &tv );
  void nextMatch( class StringGadget *search_sg,
                  RefCount<class SearchTextStorage> &ts_search,
                  class TextView *tv );

  class AWindow *win;
};

#endif
