/* wdefines.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/* $Id: wdefines.h,v 1.39 2005/03/14 22:15:11 ralf Exp $ */

#ifndef WDEFINES_H
#define WDEFINES_H

#ifndef CONFIG_H_INCLUDED
#  include <aguix/aguixconfig.h>
#  define CONFIG_H_INCLUDED
#endif

#include "worker_lfs.h"

#ifdef HAVE_AVFS
extern "C" {
#  include <virtual.h>
}
#endif

#include "worker_filefunc.h"

/* this following include isn't really needed at all
 * but the streambuf in (some?) stl implementations
 * undefing open/close (for whatever reason)
 * and this leads to problem on system supporting
 * large files with open to open64 define
 * including vector from stl (not streambuf directly
 * because it's not available everywhere) here should
 * avoid such problems but open in streambuf is not
 * accessable anymore
 * TODO: a better solution is highly wanted
 */
#include <vector>

#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <sys/param.h>  /* for MAXPATHLEN ... */
#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <math.h>
#include <time.h>
#include <sys/time.h>
#include <errno.h>
#include <grp.h>
#include <pwd.h>
#include <fnmatch.h>
#include <ctype.h>
#include <utime.h>

#if defined(HAVE_SYS_STATVFS_H)
  #include <sys/statvfs.h>
#endif
#ifdef HAVE_SYS_VFS_H
  #include <sys/vfs.h>
#endif
#ifdef HAVE_SYS_PARAM_H
  #include <sys/param.h>
#endif
#ifdef HAVE_SYS_MOUNT_H
  #include <sys/mount.h>
#endif
#ifdef HAVE_SYS_SYSINFO_H
  #include <sys/sysinfo.h>
#endif

#ifdef HAVE_REGEX
#include <regex.h>
#endif

#include <aguix/aguixdefs.h>

#ifdef HAVE_LIBZ
  #include <zlib.h>
#endif

#ifdef HAVE_LIBBZ2
  #include <bzlib.h>
#endif

#define OUTPUT_BIN "xmessage -file %s"
#define TERMINAL_BIN "xterm -e %s"

#ifndef LINUX
  #ifndef ARG_MAX
    #ifdef _POSIX_ARG_MAX
      #define ARG_MAX _POSIX_ARG_MAX
    #else
      #define ARG_MAX MAXPATHLEN
    #endif
  #endif
#endif

#define EXE_STRING_LEN ARG_MAX

#ifdef DEVELOPER
  #define USEOWNCONFIGFILES
#endif

#define w_max(a,b) (((a)>(b))?(a):(b))
#define w_min(a,b) (((a)<(b))?(a):(b))

#if ( ! defined S_ISSOCK  ) && defined S_IFSOCK
#  define S_ISSOCK(mode) ( ( (mode) & S_IFMT ) == S_IFSOCK )
#endif

#if ( ! defined S_ISLNK  ) && defined S_IFLNK
#  define S_ISLNK(mode) ( ( (mode) & S_IFMT ) == S_IFLNK )
#endif

#endif
