/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef QMainWidget_included
#define QMainWidget_included

#include <qwidget.h>

#ifdef SIMPLE_INPUT
class QLineEdit;
#else
class QComboBox;
#endif

class QPushButton;
class QBoxLayout;
class QFont;
class QString;
class QStringlist;
class QClipper;
class DiccionarioBase;
class QSimpleTextBrowser;

class QMainWidget : public QWidget //QMainWidgetData
{
    Q_OBJECT

public:

    QMainWidget(DiccionarioBase *dict, 
                QWidget* parent = NULL,const char* name = NULL
    );

    virtual ~QMainWidget();

	bool hayError() { return hay_error; };

	void setDiccionario(DiccionarioBase *dict, bool show_desc);
	DiccionarioBase *getDiccionario() { return diccionario; };

	void setClipInterval( int msec );
	int getClipInterval();

	//QCadena getLastSearch() { return last_search; };

	void checkClipboard(bool b);

	//unsigned int getNumTraducciones() { return lista.count(); };

	void setFontVista( const QFont& font);
	QFont getFontVista();

	void setTextVista( QStringList & lista );
	void setTextVista( QString texto );

	void showDesc();

	void setFormato(bool b) { con_formato=b; };
	bool getFormato() { return con_formato; };

	QSimpleTextBrowser * browser() { return vista; };


public slots:
    //void traducir(QString entrada);
	void procesaEnlace(const QString& texto);
    void aprender();
	//void changeClipProperties();
	void slot_cambiadoFontVista( const QFont& font);
//#if QT_VERSION >= 300
	void slot_changedDefaultFont( const QFont& font );
//#endif

signals:
	//void fraseTraducida(QString last_search, QString palabra, unsigned int traducciones);
	//void nuevaPalabra(QString palabra);
	//void aboutToSearch(QString link);

protected slots:
	void getClipboard(QString);
	void traduce(int item);
	void traduce_actual();

protected:
	QString createLink(const QString& palabra);

	void creaWidgets();

	DiccionarioBase *diccionario;
	QString palabra_actual;

	bool hay_error;
	bool con_formato;

	QClipper *clipper;

// Widgets que antes estaban en QMainWidgetData
	QBoxLayout *box;
	QBoxLayout *box_input;
	QPushButton *intro;
#ifdef SIMPLE_INPUT
    QLineEdit *inputText;
#else
	QComboBox *inputText;
#endif

	QSimpleTextBrowser *vista;

private:
	bool trabajando;
};

#endif // QMainWidget_included

