###############################################################################
# Enable8.0Compatibility.tcl
#
# This file implements the backward compatibility with Tcl 8.0 without need of
# change WineSetupTk source code. It's done by overloading the string and
# lrange commands, so we can easy switch back when Tcl 8.4 becomes the 
# standard.
#
# Copyright (c) 2000 by Martin Pilka for CodeWeavers
###############################################################################

# rename the real commands
rename string string_
rename lrange lrange_

# wrapper for string command
proc string {aCmd aStr args} {
  if {$aCmd == "index"} {
    set Idx [lindex $args 0]
    regsub end $Idx [expr [string_ length $aStr]-1] Idx
    set Idx [expr $Idx]
    set args [lreplace $args 0 0 $Idx]
  }
  if {$aCmd == "range"} {
    set Idx [lindex $args 0]
    regsub end $Idx [expr [string_ length $aStr]-1] Idx
    set Idx [expr $Idx]
    set args [lreplace $args 0 0 $Idx]    

    set Idx [lindex $args 1]
    regsub end $Idx [expr [string_ length $aStr]-1] Idx
    set Idx [expr $Idx]
    set args [lreplace $args 1 1 $Idx]    
  }
  if {$aCmd == "compare" && $aStr == "-nocase"} {
    set Str1 [lindex $args 0]
    set Str2 [lindex $args 1]
    set Str1 [string_ toupper $Str1]
    set Str2 [string_ toupper $Str2]
    return [string_ compare $Str1 $Str2]
  }
  eval string_ $aCmd [list $aStr] $args
}

# wrapper for lrange command
proc lrange {aList aFrom aTo} {
  regsub end $aFrom [expr [llength $aList]-1] From
  set From [expr $From]
  
  regsub end $aTo [expr [llength $aList]-1] To
  set To [expr $To]

  eval lrange_ [list $aList] $From $To
}

####################################
# ok, let's stop that dirty tricks #
####################################


