package winmm;

use strict;

require Exporter;

use wine;
use vars qw(@ISA @EXPORT @EXPORT_OK);

@ISA = qw(Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();

my $module_declarations = {
    "CloseDriver" => ["long",  ["long", "long", "long"]],
    "DefDriverProc" => ["long",  ["long", "long", "long", "long", "long"]],
    "DriverCallback" => ["long",  ["long", "long", "long", "long", "long", "long", "long"]],
    "DrvClose" => ["long",  ["long", "long", "long"]],
    "DrvDefDriverProc" => ["long",  ["long", "long", "long", "long", "long"]],
    "DrvGetModuleHandle" => ["long",  ["long"]],
    "DrvOpen" => ["long",  ["wstr", "wstr", "long"]],
    "DrvOpenA" => ["long",  ["str", "str", "long"]],
    "DrvSendMessage" => ["long",  ["long", "long", "long", "long"]],
    "GetDriverFlags" => ["long",  ["long"]],
    "GetDriverModuleHandle" => ["long",  ["long"]],
    "OpenDriver" => ["long",  ["wstr", "wstr", "long"]],
    "OpenDriverA" => ["long",  ["str", "str", "long"]],
    "PlaySound" => ["long",  ["str", "long", "long"]],
    "PlaySoundA" => ["long",  ["str", "long", "long"]],
    "PlaySoundW" => ["long",  ["wstr", "long", "long"]],
    "SendDriverMessage" => ["long",  ["long", "long", "long", "long"]],
    "auxGetDevCapsA" => ["long",  ["long", "ptr", "long"]],
    "auxGetDevCapsW" => ["long",  ["long", "ptr", "long"]],
    "auxGetNumDevs" => ["long",  []],
    "auxGetVolume" => ["long",  ["long", "ptr"]],
    "auxOutMessage" => ["long",  ["long", "long", "long", "long"]],
    "auxSetVolume" => ["long",  ["long", "long"]],
    "joyGetDevCapsA" => ["long",  ["long", "ptr", "long"]],
    "joyGetDevCapsW" => ["long",  ["long", "ptr", "long"]],
    "joyGetNumDevs" => ["long",  []],
    "joyGetPos" => ["long",  ["long", "ptr"]],
    "joyGetPosEx" => ["long",  ["long", "ptr"]],
    "joyGetThreshold" => ["long",  ["long", "ptr"]],
    "joyReleaseCapture" => ["long",  ["long"]],
    "joySetCapture" => ["long",  ["long", "long", "long", "long"]],
    "joySetThreshold" => ["long",  ["long", "long"]],
    "mciDriverNotify" => ["long",  ["long", "long", "long"]],
    "mciDriverYield" => ["long",  ["long"]],
    "mciExecute" => ["long",  ["str"]],
    "mciFreeCommandResource" => ["long",  ["long"]],
    "mciGetCreatorTask" => ["long",  ["long"]],
    "mciGetDeviceIDA" => ["long",  ["str"]],
    "mciGetDeviceIDFromElementIDW" => ["long",  ["long", "wstr"]],
    "mciGetDeviceIDW" => ["long",  ["wstr"]],
    "mciGetDriverData" => ["long",  ["long"]],
    "mciGetErrorStringA" => ["long",  ["long", "str", "long"]],
    "mciGetErrorStringW" => ["long",  ["long", "wstr", "long"]],
    "mciGetYieldProc" => ["ptr",  ["long", "ptr"]],
    "mciLoadCommandResource" => ["long",  ["long", "wstr", "long"]],
    "mciSendCommandA" => ["long",  ["long", "long", "long", "long"]],
    "mciSendCommandW" => ["long",  ["long", "long", "long", "long"]],
    "mciSendStringA" => ["long",  ["str", "str", "long", "long"]],
    "mciSendStringW" => ["long",  ["wstr", "str", "long", "long"]],
    "mciSetDriverData" => ["long",  ["long", "long"]],
    "mciSetYieldProc" => ["long",  ["long", "ptr", "long"]],
    "midiInAddBuffer" => ["long",  ["long", "ptr", "long"]],
    "midiInClose" => ["long",  ["long"]],
    "midiInGetDevCapsA" => ["long",  ["long", "ptr", "long"]],
    "midiInGetDevCapsW" => ["long",  ["long", "ptr", "long"]],
    "midiInGetErrorTextA" => ["long",  ["long", "str", "long"]],
    "midiInGetErrorTextW" => ["long",  ["long", "wstr", "long"]],
    "midiInGetID" => ["long",  ["long", "ptr"]],
    "midiInGetNumDevs" => ["long",  []],
    "midiInMessage" => ["long",  ["long", "long", "long", "long"]],
    "midiInOpen" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "midiInPrepareHeader" => ["long",  ["long", "ptr", "long"]],
    "midiInReset" => ["long",  ["long"]],
    "midiInStart" => ["long",  ["long"]],
    "midiInStop" => ["long",  ["long"]],
    "midiInUnprepareHeader" => ["long",  ["long", "ptr", "long"]],
    "midiOutCacheDrumPatches" => ["long",  ["long", "long", "ptr", "long"]],
    "midiOutCachePatches" => ["long",  ["long", "long", "ptr", "long"]],
    "midiOutClose" => ["long",  ["long"]],
    "midiOutGetDevCapsA" => ["long",  ["long", "ptr", "long"]],
    "midiOutGetDevCapsW" => ["long",  ["long", "ptr", "long"]],
    "midiOutGetErrorTextA" => ["long",  ["long", "str", "long"]],
    "midiOutGetErrorTextW" => ["long",  ["long", "wstr", "long"]],
    "midiOutGetID" => ["long",  ["long", "ptr"]],
    "midiOutGetNumDevs" => ["long",  []],
    "midiOutGetVolume" => ["long",  ["long", "ptr"]],
    "midiOutLongMsg" => ["long",  ["long", "ptr", "long"]],
    "midiOutMessage" => ["long",  ["long", "long", "long", "long"]],
    "midiOutOpen" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "midiOutPrepareHeader" => ["long",  ["long", "ptr", "long"]],
    "midiOutReset" => ["long",  ["long"]],
    "midiOutSetVolume" => ["long",  ["long", "long"]],
    "midiOutShortMsg" => ["long",  ["long", "long"]],
    "midiOutUnprepareHeader" => ["long",  ["long", "ptr", "long"]],
    "midiStreamClose" => ["long",  ["long"]],
    "midiStreamOpen" => ["long",  ["ptr", "ptr", "long", "long", "long", "long"]],
    "midiStreamOut" => ["long",  ["long", "ptr", "long"]],
    "midiStreamPause" => ["long",  ["long"]],
    "midiStreamPosition" => ["long",  ["long", "ptr", "long"]],
    "midiStreamProperty" => ["long",  ["long", "ptr", "long"]],
    "midiStreamRestart" => ["long",  ["long"]],
    "midiStreamStop" => ["long",  ["long"]],
    "mixerClose" => ["long",  ["long"]],
    "mixerGetControlDetailsA" => ["long",  ["long", "ptr", "long"]],
    "mixerGetControlDetailsW" => ["long",  ["long", "ptr", "long"]],
    "mixerGetDevCapsA" => ["long",  ["long", "ptr", "long"]],
    "mixerGetDevCapsW" => ["long",  ["long", "ptr", "long"]],
    "mixerGetID" => ["long",  ["long", "ptr", "long"]],
    "mixerGetLineControlsA" => ["long",  ["long", "ptr", "long"]],
    "mixerGetLineControlsW" => ["long",  ["long", "ptr", "long"]],
    "mixerGetLineInfoA" => ["long",  ["long", "ptr", "long"]],
    "mixerGetLineInfoW" => ["long",  ["long", "ptr", "long"]],
    "mixerGetNumDevs" => ["long",  []],
    "mixerMessage" => ["long",  ["long", "long", "long", "long"]],
    "mixerOpen" => ["long",  ["ptr", "long", "long", "long", "long"]],
    "mixerSetControlDetails" => ["long",  ["long", "ptr", "long"]],
    "mmioAdvance" => ["long",  ["long", "ptr", "long"]],
    "mmioAscend" => ["long",  ["long", "ptr", "long"]],
    "mmioClose" => ["long",  ["long", "long"]],
    "mmioCreateChunk" => ["long",  ["long", "ptr", "long"]],
    "mmioDescend" => ["long",  ["long", "ptr", "ptr", "long"]],
    "mmioFlush" => ["long",  ["long", "long"]],
    "mmioGetInfo" => ["long",  ["long", "ptr", "long"]],
    "mmioInstallIOProcA" => ["ptr",  ["long", "ptr", "long"]],
    "mmioInstallIOProcW" => ["ptr",  ["long", "ptr", "long"]],
    "mmioOpenA" => ["long",  ["str", "ptr", "long"]],
    "mmioOpenW" => ["long",  ["wstr", "ptr", "long"]],
    "mmioRead" => ["long",  ["long", "ptr", "long"]],
    "mmioRenameA" => ["long",  ["str", "str", "ptr", "long"]],
    "mmioRenameW" => ["long",  ["wstr", "wstr", "ptr", "long"]],
    "mmioSeek" => ["long",  ["long", "long", "long"]],
    "mmioSendMessage" => ["long",  ["long", "long", "long", "long"]],
    "mmioSetBuffer" => ["long",  ["long", "str", "long", "long"]],
    "mmioSetInfo" => ["long",  ["long", "ptr", "long"]],
    "mmioStringToFOURCCA" => ["long",  ["str", "long"]],
    "mmioStringToFOURCCW" => ["long",  ["wstr", "long"]],
    "mmioWrite" => ["long",  ["long", "ptr", "long"]],
    "mmsystemGetVersion" => ["long",  []],
    "sndPlaySoundA" => ["long",  ["str", "long"]],
    "sndPlaySoundW" => ["long",  ["wstr", "long"]],
    "timeBeginPeriod" => ["long",  ["long"]],
    "timeEndPeriod" => ["long",  ["long"]],
    "timeGetDevCaps" => ["long",  ["ptr", "long"]],
    "timeGetSystemTime" => ["long",  ["ptr", "long"]],
    "timeGetTime" => ["long",  []],
    "timeKillEvent" => ["long",  ["long"]],
    "timeSetEvent" => ["long",  ["long", "long", "ptr", "long", "long"]],
    "waveInAddBuffer" => ["long",  ["long", "ptr", "long"]],
    "waveInClose" => ["long",  ["long"]],
    "waveInGetDevCapsA" => ["long",  ["long", "ptr", "long"]],
    "waveInGetDevCapsW" => ["long",  ["long", "ptr", "long"]],
    "waveInGetErrorTextA" => ["long",  ["long", "str", "long"]],
    "waveInGetErrorTextW" => ["long",  ["long", "wstr", "long"]],
    "waveInGetID" => ["long",  ["long", "ptr"]],
    "waveInGetNumDevs" => ["long",  []],
    "waveInGetPosition" => ["long",  ["long", "ptr", "long"]],
    "waveInMessage" => ["long",  ["long", "long", "long", "long"]],
    "waveInOpen" => ["long",  ["ptr", "long", "ptr", "long", "long", "long"]],
    "waveInPrepareHeader" => ["long",  ["long", "ptr", "long"]],
    "waveInReset" => ["long",  ["long"]],
    "waveInStart" => ["long",  ["long"]],
    "waveInStop" => ["long",  ["long"]],
    "waveInUnprepareHeader" => ["long",  ["long", "ptr", "long"]],
    "waveOutBreakLoop" => ["long",  ["long"]],
    "waveOutClose" => ["long",  ["long"]],
    "waveOutGetDevCapsA" => ["long",  ["long", "ptr", "long"]],
    "waveOutGetDevCapsW" => ["long",  ["long", "ptr", "long"]],
    "waveOutGetErrorTextA" => ["long",  ["long", "str", "long"]],
    "waveOutGetErrorTextW" => ["long",  ["long", "wstr", "long"]],
    "waveOutGetID" => ["long",  ["long", "ptr"]],
    "waveOutGetNumDevs" => ["long",  []],
    "waveOutGetPitch" => ["long",  ["long", "ptr"]],
    "waveOutGetPlaybackRate" => ["long",  ["long", "ptr"]],
    "waveOutGetPosition" => ["long",  ["long", "ptr", "long"]],
    "waveOutGetVolume" => ["long",  ["long", "ptr"]],
    "waveOutMessage" => ["long",  ["long", "long", "long", "long"]],
    "waveOutOpen" => ["long",  ["ptr", "long", "ptr", "long", "long", "long"]],
    "waveOutPause" => ["long",  ["long"]],
    "waveOutPrepareHeader" => ["long",  ["long", "ptr", "long"]],
    "waveOutReset" => ["long",  ["long"]],
    "waveOutRestart" => ["long",  ["long"]],
    "waveOutSetPitch" => ["long",  ["long", "long"]],
    "waveOutSetPlaybackRate" => ["long",  ["long", "long"]],
    "waveOutSetVolume" => ["long",  ["long", "long"]],
    "waveOutUnprepareHeader" => ["long",  ["long", "ptr", "long"]],
    "waveOutWrite" => ["long",  ["long", "ptr", "long"]]
};

&wine::declare("winmm",%$module_declarations);
push @EXPORT, map { "&" . $_; } sort(keys(%$module_declarations));
1;
