.\" -*- nroff -*-
.TH WINE.CONF 5 "September 1, 2001" "Version 20010824" "Wine Configuration File"
.SH NAME
wine.conf \- Wine configuration file
.SH DESCRIPTION
.B wine
expects a configuration file (
.I $WINEPREFIX/config
(~/.wine/config)
), which should conform to the following rules. 
A sample configuration file is available as
.I documentation/samples/config
in the Wine source distribution.
.SH CONFIGURATION FILE FORMAT
All entries are grouped in sections; a section begins with the line
.br
.I [section name]
.br
and continues until the next section starts. Individual entries
consist of lines of the form
.br
.I """entry""=""value"""
.br
The entry and value can be any text strings, included in double
quotes; it can also contain references to environment variables
surrounded by
.I ${}.
Inside the double quotes, special characters, backslashes and quotes
must be escaped with backslashes. Supported section names and entries
are listed below.
.PP
.B [Drive X]
.br
This section is used to specify the root directory and type of each emulated
.B DOS
drive, since most Windows applications require a DOS/MS-Windows based 
disk drive & directory scheme, which is either provided by a real
DOS partition mounted somewhere or by some carefully crafted directory layout
on a Unix file system ("no-windows fake installation").
There is one such section for every drive you want to configure.
.PP
.I format: """Path""=""<rootdirectory>"""
.br
default: none
.br
If you mounted your dos partition as 
.I /dos
and installed Microsoft Windows in 
C:\\WINDOWS (thus it shows up as /dos/WINDOWS), then you should specify 
.I """Path""=""/dos"""
in the
.I [Drive C]
section in order to configure /dos as the drive root of drive C:.
.PP
.I format: """Type""=""<type>"""
.br
default: "hd"
.br
Used to specify the drive type this drive appears as in Windows
or DOS programs; supported types are "floppy", "hd", "cdrom"
and "network".
.PP
.I format: """Label""=""<label>"""
.br
default: "Drive X"
.br
Used to specify the drive label; limited to 11 characters.
.PP
.I format: """Serial""=""<serial>"""
.br
default: "12345678"
.br
Used to specify the drive serial number, as an 8-character hexadecimal
number.
.PP
.I format: """Filesystem""=""<fstype>"""
.br
default: "win95"
.br
Used to specify the type of the file system Wine should emulate on a given
directory structure/underlying file system.
.br
Supported types are "msdos" (or "fat"), "win95" (or "vfat"), "unix".
.br
Recommended:
.br
  "win95" for ext2fs, ReiserFS, ..., VFAT and FAT32
.br
  "msdos" for FAT16 file systems (ugly, 8.3 naming)
.br
You definitely do not want to use "unix" unless you intend to port
programs using Winelib.  Always try to avoid using a FAT16 FS. Use the
VFAT/FAT32 OS file system driver instead.
.PP
.I format: """FailReadOnly""=""<boolean>"""
.br
Read-only files may not be opened in write mode (the default is to
allow opening read-only files for writing, because most Windows
programs always request read-write access, even on CD-ROM drives...).
.PP
.B [wine]
.br
.I format: """windows""=""<directory>"""
.br
default: "C:\\\\WINDOWS"
.br
Used to specify where Wine is supposed to have its Windows directory
(which is an essential part of a Windows environment); make sure to double
the backslashes.
In case of e.g. C:\\WINDOWS, with drive C: being configured as
/home/user/wine_c, the /home/user/wine_c/WINDOWS directory would be used for
this.
.PP
.I format: """system""=""<directory>"""
.br
default: "C:\\\\WINDOWS\\\\System"
.br
Used to specify where Wine is supposed to have its Windows system directory
(again, essential part of Windows environment); make sure to double the backslashes.
Given a setting of C:\\WINDOWS\\System (the standard setting on Windows)
and a C: drive again at /home/user/wine_c, the /home/user/wine_c/WINDOWS/System
directory would be used for this.
.PP
.I format: """temp""=""<directory>"""
.br
default: "C:\\\\TEMP"
.br
Used to specify a directory where Windows applications can store 
temporary files. E.g. with a C: drive at /home/user/wine_c, this would be
the /home/user/wine_c/TEMP directory.
.PP
.I format: """profile""=""<directory>"""
.br
default: nothing
.br
Used to specify a directory where Windows stores special folders and
the user-registry files (user.dat or ntuser.dat).  Mapped to
environment variable %USERPROFILE%.  Set this value when running with
a native NT or a native win95 directory with per-user settings.
.PP
.I format: """path""=""<directories separated by semi-colons>"""
.br
default: "C:\\\\WINDOWS;C:\\\\WINDOWS\\\\SYSTEM"
.br
Used to specify the path which will be used to find executables and
dlls. Make sure to double the backslashes.
.PP
.I format: """GraphicsDriver""=""<x11drv|ttydrv>"""
.br
default: "x11drv"
.br
Tells Wine which graphics driver to use. Normally you'd want to use
x11drv (for X11). In case you want to run programs as text console/TTY only
without having Wine rely on X11 support, then use ttydrv.
.PP
.B [DllOverrides]
.br
.I format: """modulename""=""native,so,builtin"""
.br
.I modulename
can be any valid DLL module name, without extension. The specified value
is a comma separated list of module-types to try to load in that
specific order. Case is not important and only the first letter of
each type is enough to identify the type n[ative], s[o],
b[uiltin]. Also whitespace is ignored. See also commandline option
.I --dll
for details about the allowable types.
.br
The wildcard entry
.I """*"""
specifies the load order to use for modules not explicitly
mentioned. If the wildcard entry is not found, then the order
"native,builtin,so" is used.
.br
Examples:
.br
.I """kernel32""=""builtin"""
.br
.I """kernel""=""builtin"""
.br
.I """comdlg32""=""native,builtin"""
.br
.I """*""=""builtin,native"""
.br
Changing the load order of kernel/kernel32 and gdi/gdi32 to
anything other than builtin will cause wine to fail because wine cannot
use native versions for these libraries.
.br
Always make sure that you have some kind of strategy in mind when you start
fiddling with the current defaults and needless to say that you must know
what you are doing.
--debugmsg +loaddll might come in handy for experimenting with that stuff.
.PP
.B [serialports]
.br
.I format: """com[12345678]""=""<devicename>"""
.br
default: none
.br
Used to specify the devices which are used as COM1 - COM8.
.PP
.B [parallelports]
.br
.I format: """lpt[12345678]""=""<devicename>"""
.br
default: none
.br
Used to specify the devices which are used as LPT1 - LPT8.
.PP
.B [spy]
.br
.I format: """exclude""=""<message names separated by semicolons>"""
.br
default: none
.br
Used to specify which messages will be excluded from the logfile.
.PP
.I format: """include""=""<message names separated by semicolons>"""
.br
default: none
.br Used to specify which messages will be included in the logfile.
.PP
.B [Tweak.Layout]
.br
.I format: """WineLook""=""<Win31|Win95|Win98>"""
.br
default: "Win31"
.br 
Use Win95-like window displays or Win3.1-like window displays.
.PP
.B [Registry]
.br
.I format: """LoadGlobalRegistryFiles""=""<boolean>"""
.br
Global registries (stored in /etc)
.PP
.I format: """LoadHomeRegistryFiles""=""<boolean>"""
.br
Home registries (stored in ~user/.wine/)
.PP
.I format: """WritetoHomeRegistryFiles""=""<boolean>"""
.br
TRY to write all changes to the home registry files
.PP
.I format: """LoadWindowsRegistryFiles""=""<boolean>"""
.br
Load Windows registry from the current Windows directory. 
.PP
booleans: Y/y/T/t/1 are true, N/n/F/f/0 are false.
.br
Defaults are read all, write to home files.
.PP
.B [AppDefaults\\\\\\\\<appname>\\\\\\\\...]
.PP
This section allows specifying application-specific values for
the other sections described above.
.I <appname>
is the name of the application exe file, without path. The "..."
should be replaced by the name of one of the above configuration
sections.
.br
Example:
.br
.I [AppDefaults\\\\\\\\sol.exe\\\\\\\\DllOverrides]
.br
.I """shell32""" = """native"""
.br
means that Solitaire will use "native" load order for the shell32
dll. All other applications will continue to use what was specified in
the general
.I DllOverrides
section.
.br
The only sections that support application-specific information at the
moment are
.I DllOverrides 
and 
.I x11drv.
.br
Make sure to use double backslashes in the section name.
.PP
.SH SAMPLE CONFIGURATION FILE
A sample configuration file is distributed as
.B documentation/samples/config
in the Wine source distribution.
.SH FILES
.TP
.I ~/.wine/config
User-specific configuration file
.SH ENVIRONMENT VARIABLES
.TP 
.I WINEPREFIX
Specifies the directory that contains the per-user
.I config
file, the registry files, and the wineserver socket. The default is
.I $HOME/.wine.
.SH "SEE ALSO"
.BR wine (1)
