/*
 * NodeLoadSensor.cpp
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include "stdafx.h"

#include "NodeLoadSensor.h"
#include "Proto.h"
#include "FieldValue.h"
#include "SFBool.h"
#include "SFNode.h"
#include "SFTime.h"
#include "SFFloat.h"
#include "MFNode.h"
#include "DuneApp.h"
#include "Field.h"

ProtoLoadSensor::ProtoLoadSensor(Scene *scene)
  : Proto(scene, "LoadSensor")
{
    enabled.set(
          addExposedField(SFBOOL, "enabled", new SFBool(true)));
    metadata.set(
          addExposedField(SFNODE, "metadata", new SFNode(NULL)));
    timeOut.set(
          addExposedField(SFTIME, "timeOut", new SFTime(0.0)));
    watchList.set(
          addExposedField(MFNODE, "watchList", new MFNode(), URL_NODE));
    addEventOut(SFBOOL, "isActive"); 
    addEventOut(SFBOOL, "isLoaded"); 
    addEventOut(SFTIME, "loadTime", EOF_RECOMMENDED);
    addEventOut(SFFLOAT, "progress");
}

Node *
ProtoLoadSensor::create(Scene *scene)
{ 
   return new NodeLoadSensor(scene, this); 
}

NodeLoadSensor::NodeLoadSensor(Scene *scene, Proto *def)
  : Node(scene, def)
{
}

bool
NodeLoadSensor::writeEXTERNPROTO(int f)
{
    RET_ONERROR( mywritestr(f ,"EXTERNPROTO LoadSensor[\n") )    
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," exposedField SFBool enabled\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," exposedField SFNode metadata\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," exposedField SFTime timeOut\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," exposedField MFNode watchList\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," eventOut SFBool isActive\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," eventOut SFBool isLoaded\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," eventOut SFTime loadTime\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," eventOut SFFloat progress\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," ]\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ,"[\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ," \"urn:web3d:x3d:node:LoadSensor\",\n") )
    TheApp->incSelectionLinenumber();
#ifdef HAVE_X3D_DRAFT_PROTO_URL
    RET_ONERROR( mywritestr(f ," \"") )
    RET_ONERROR( mywritestr(f ,HAVE_X3D_DRAFT_PROTO_URL) )
    RET_ONERROR( mywritestr(f ,"/LoadSensorPROTO.wrl") )
    RET_ONERROR( mywritestr(f ,"\"\n") )
    TheApp->incSelectionLinenumber();
#else
    RET_ONERROR( mywritestr(f ," \"LoadSensorPROTO.wrl\",\n") )
    TheApp->incSelectionLinenumber();
#endif
    RET_ONERROR( mywritestr(f ," \"http://www.csv.ica.uni-stuttgart.de/vrml/dune/docs/x3dDraft/LoadSensorPROTO.wrl\"\n") )
    TheApp->incSelectionLinenumber();
    RET_ONERROR( mywritestr(f ,"]\n") )
    TheApp->incSelectionLinenumber();
    return true;
}

