/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux 

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

// writtten May 1999



#ifndef _SAMPLE_H
#define _SAMPLE_H

#include <wftk/sound.h>
#include <wftk/resources.h>

#include <string>

namespace wftk {

/// Sample - for loading / playing sounds
class Sample : public Sound
{

public:

  ///
  Sample() : data_(0), channel_(-1) {}
  /// make a copy of a sample
  Sample(const Sample&);
  /// load a sample from a file
  Sample(const std::string& filename) : channel_(-1) {load(filename);}
  ///
  virtual ~Sample();


  /// set volume (0..100)
  virtual int setVolume(int vol);  
  ///
  virtual bool load(const std::string&);
  ///
  virtual bool play(int loops = 0) const;
  ///
  virtual void stop() const;
  ///
  virtual bool playing() const;

  /** Load digital sound (wav) from file
   *
   * Use the \b load() function to load a sample (wav) from a file on disk and 
   * register it with wftk's Resources engine, e.g.:
   * \code
   *   Sample::registry.load("press","press.wav");
   * \endcode
   * Use the \b find() function to retrieve a pointer to the Sample object.  If the
   * named sample has not been registered, find() will return 0.
   * \code
   *   Sample::registry.find("alert")->play();
   * \endcode
   */
  static ResourceRegistry<Sample*> registry;
  /// refcounted resource type
  typedef Resource<Sample*> Resource;

 private:

  ///
  void* data_; // Mix_Chunk*
  ///
  mutable int channel_;

};

} // namespace

#endif
