#!/usr/local/bin/perl
# Do an immediate virtual server backup

require './virtual-server-lib.pl';
&master_admin() || &error($text{'backup_ecannot'});
&ReadParse();

# Validate inputs
&error_setup($text{'backup_err'});
if ($in{'all'} == 1) {
	@doms = &list_domains();
	}
elsif ($in{'all'} == 2) {
	%exc = map { $_, 1 } split(/\0/, $in{'doms'});
	@doms = grep { !$exc{$_->{'id'}} } &list_domains();
	}
else {
	foreach $d (split(/\0/, $in{'doms'})) {
		push(@doms, &get_domain($d));
		}
	}
@doms || &error($text{'backup_edoms'});
@do_features = split(/\0/, $in{'feature'});
@do_features || &error($text{'backup_efeatures'});
$dest = &parse_backup_destination("dest", \%in);
$dest = &backup_strftime($dest) if ($in{'strftime'});

# Parse option inputs
foreach $f (@do_features) {
	local $ofunc = "parse_backup_$f";
	if (defined(&$ofunc)) {
		$options{$f} = &$ofunc(\%in);
		}
	}

if (defined($in{'dom'})) {
	# Save domain-specific backup options
	$d = &get_domain($in{'dom'});
	$d->{'backup_dest'} = $dest;
	$d->{'backup_fmt'} = $in{'backup_fmt'};
	$d->{'backup_errors'} = $in{'backup_errors'};
	$d->{'backup_strftime'} = $in{'backup_strftime'};
	&save_domain($d);
	}

&ui_print_unbuffered_header(undef, $text{'backup_title'}, "");

print "<p>",&text('backup_doing', scalar(@doms),
				  "<tt>$dest</tt>"),"<p>\n";
($ok, $size) = &backup_domains($dest, \@doms, \@do_features,
			       $in{'fmt'}, $in{'errors'}, \%options);
&run_post_actions();
if (!$ok) {
	unlink($dest);
	print "<p>",$text{'backup_failed'},"<p>\n";
	}
else {
	print "<p>",&text('backup_done', &nice_size($size)),"<p>\n";
	&webmin_log("backup", $dest, undef,
		    { 'doms' => [ map { $_->{'dom'} } @doms ] });
	}

&ui_print_footer("", $text{'index_return'});


