# generics-lib.pl
# Functions for the generics table

# generics_dbm(&config)
# Returns the filename and type of the generics database, or undef if none
sub generics_dbm
{
foreach $f (&find_type("K", $_[0])) {
        if ($f->{'value'} =~ /^generics\s+(\S+)[^\/]+(\S+)$/) {
		return ($2, $1);
                }
	}
return undef;
}

# generics_file(&config)
# Returns the filename of the text generics file, or undef if none
sub generics_file
{
return &find_textfile($config{'generics_file'}, &generics_dbm($_[0]));
}

# list_generics(textfile)
sub list_generics
{
if (!defined(@list_generics_cache)) {
	@list_generics_cache = ( );
	local $lnum = 0;
	open(GEN, $_[0]);
	while(<GEN>) {
		s/\r|\n//g;     # remove newlines
		s/#.*$//g;	# remove comments
		if (/^(\S+)\s+(.*)/) {
			local(%gen);
			$gen{'from'} = $1;
			$gen{'to'} = $2;
			$gen{'line'} = $lnum;
			$gen{'file'} = $_[0];
			$gen{'num'} = scalar(@list_generics_cache);
			push(@list_generics_cache, \%gen);
			}
		$lnum++;
		}
	close(GEN);
	}
return @list_generics_cache;
}

# create_generic(&details, textfile, dbmfile, dbmtype)
# Create a new generic mapping
sub create_generic
{
&list_generics($_[1]);	# force cache init
local(%virt);
local $lref = &read_file_lines($_[1]);
push(@$lref, "$_[0]->{'from'}\t$_[0]->{'to'}");
&flush_file_lines();
if ($_[3] eq "dbm") {
	dbmopen(%virt, $_[2], 0644);
	$virt{$_[0]->{'from'}} = $_[0]->{'to'};
	dbmclose(%virt);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }

$_[0]->{'line'} = @$lref-1;
$_[0]->{'num'} = scalar(@list_generics_cache);
push(@list_generics_cache, $_[0]);
}

# delete_generic(&details, textfile, dbmfile, dbmtype)
# Delete an existing generic mapping
sub delete_generic
{
local(%virt);
local $lref = &read_file_lines($_[1]);
splice(@$lref, $_[0]->{'line'}, 1);
&flush_file_lines();
if ($_[3] eq "dbm") {
	dbmopen(%virt, $_[2], 0644);
	delete($virt{$_[0]->{'from'}});
	dbmclose(%virt);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }

local $idx = &indexof($_[0], @list_generics_cache);
splice(@list_generics_cache, $idx, 1) if ($idx != -1);
&renumber_list(\@list_generics_cache, $_[0], -1);
}

# modify_generic(&old, &details, textfile, dbmfile, dbmtype)
# Change an existing generic
sub modify_generic
{
local(%virt);
local $lref = &read_file_lines($_[2]);
$lref->[$_[0]->{'line'}] = "$_[1]->{'from'}\t$_[1]->{'to'}";
&flush_file_lines();
if ($_[4] eq "dbm") {
	dbmopen(%virt, $_[3], 0644);
	delete($virt{$_[0]->{'from'}});
	$virt{$_[1]->{'from'}} = $_[1]->{'to'};
	dbmclose(%virt);
	}
else { &run_makemap($_[2], $_[3], $_[4]); }

local $idx = &indexof($_[0], @list_generics_cache);
$_[1]->{'line'} = $_[0]->{'line'};
$list_generics_cache[$idx] = $_[1] if ($idx != -1);
}

sub generic_form([&details])
{
local $g = $_[0];
print "<form action=save_generic.cgi>\n";
if ($g) { print "<input type=hidden name=num value=$g->{'num'}>\n"; }
else { print "<input type=hidden name=new value=1>\n"; }
print "<table border>\n";
print "<tr $tb> <td><b>",$g ? $text{'gform_edit'} : $text{'gform_create'},
      "</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'gform_from'}</b></td>\n";
print "<td><input name=from size=30 value=\"$g->{'from'}\"></td> </tr>\n";
print "<tr> <td><b>$text{'gform_to'}</b></td>\n";
print "<td><input name=to size=30 value=\"$g->{'to'}\"></td> </tr>\n";

print "<tr> <td colspan=3 align=right>\n";
if ($_[0]) {
        print "<input type=submit value=\"$text{'save'}\">\n";
        print "<input type=submit name=delete value=\"$text{'delete'}\">\n";
        }
else { print "<input type=submit value=\"$text{'create'}\">\n"; }
print "</td> </tr>\n";
print "</table></td></tr></table></form>\n";
}

1;

